/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.nbimpl.javac;

import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.modules.profiler.api.java.SourceMethodInfo;
import org.netbeans.modules.profiler.nbimpl.javac.ElementUtilitiesEx;

public class JavacMethodInfo
extends SourceMethodInfo {
    private ElementHandle<ExecutableElement> handle;

    public JavacMethodInfo(ExecutableElement method, CompilationController cc) {
        super(ElementUtilities.getBinaryName((TypeElement)((TypeElement)method.getEnclosingElement())), method.getSimpleName().toString(), ElementUtilitiesEx.getBinaryName(method, (CompilationInfo)cc), JavacMethodInfo.getVMMethodName(method), JavacMethodInfo.isExecutable(method), JavacMethodInfo.convertModifiers(method.getModifiers()));
        this.handle = ElementHandle.create((Element)method);
    }

    public ExecutableElement resolve(CompilationController cc) {
        return (ExecutableElement)this.handle.resolve((CompilationInfo)cc);
    }

    private static boolean isExecutable(ExecutableElement method) {
        if (method == null) {
            return false;
        }
        Set<Modifier> modifiers = method.getModifiers();
        return !modifiers.contains((Object)Modifier.ABSTRACT) && !modifiers.contains((Object)Modifier.NATIVE);
    }

    private static String getVMMethodName(ExecutableElement method) {
        return method.getSimpleName().toString();
    }

    public String toString() {
        return this.getClassName() + "." + this.getName() + this.getSignature();
    }

    private static int convertModifiers(Set<Modifier> mods) {
        int modifiers = 0;
        if (mods.contains((Object)Modifier.ABSTRACT)) {
            modifiers |= 0x400;
        }
        if (mods.contains((Object)Modifier.FINAL)) {
            modifiers |= 0x10;
        }
        if (mods.contains((Object)Modifier.NATIVE)) {
            modifiers |= 0x100;
        }
        if (mods.contains((Object)Modifier.PRIVATE)) {
            modifiers |= 2;
        }
        if (mods.contains((Object)Modifier.PROTECTED)) {
            modifiers |= 4;
        }
        if (mods.contains((Object)Modifier.PUBLIC)) {
            modifiers |= 1;
        }
        if (mods.contains((Object)Modifier.STATIC)) {
            modifiers |= 8;
        }
        if (mods.contains((Object)Modifier.STRICTFP)) {
            modifiers |= 0x800;
        }
        if (mods.contains((Object)Modifier.SYNCHRONIZED)) {
            modifiers |= 0x20;
        }
        if (mods.contains((Object)Modifier.TRANSIENT)) {
            modifiers |= 0x80;
        }
        if (mods.contains((Object)Modifier.VOLATILE)) {
            modifiers |= 0x40;
        }
        return modifiers;
    }
}

