/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.file.BaseFileObject;
import com.sun.tools.javac.file.JavacFileManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.Normalizer;
import java.util.Objects;
import javax.tools.JavaFileObject;

class RegularFileObject
extends BaseFileObject {
    private boolean hasParents = false;
    private String name;
    final Path file;
    private Reference<Path> absFileRef;
    static final boolean isMacOS = System.getProperty("os.name", "").contains("OS X");

    public RegularFileObject(JavacFileManager fileManager, Path f) {
        this(fileManager, f.getFileName().toString(), f);
    }

    public RegularFileObject(JavacFileManager fileManager, String name, Path f) {
        super(fileManager);
        if (Files.isDirectory(f, new LinkOption[0])) {
            throw new IllegalArgumentException("directories not supported");
        }
        this.name = name;
        this.file = f;
        if (this.getLastModified() > System.currentTimeMillis()) {
            fileManager.log.warning("file.from.future", f);
        }
    }

    @Override
    public URI toUri() {
        return this.file.toUri().normalize();
    }

    @Override
    public String getName() {
        return this.file.toString();
    }

    @Override
    public String getShortName() {
        return this.name;
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return RegularFileObject.getKind(this.name);
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return Files.newInputStream(this.file, new OpenOption[0]);
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        this.fileManager.flushCache(this);
        this.ensureParentDirectoriesExist();
        return Files.newOutputStream(this.file, new OpenOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharBuffer getCharContent(boolean ignoreEncodingErrors) throws IOException {
        CharBuffer cb = this.fileManager.getCachedContent(this);
        if (cb == null) {
            try (InputStream in = Files.newInputStream(this.file, new OpenOption[0]);){
                ByteBuffer bb = this.fileManager.makeByteBuffer(in);
                JavaFileObject prev = this.fileManager.log.useSource(this);
                try {
                    cb = this.fileManager.decode(bb, ignoreEncodingErrors);
                }
                finally {
                    this.fileManager.log.useSource(prev);
                }
                this.fileManager.recycleByteBuffer(bb);
                if (!ignoreEncodingErrors) {
                    this.fileManager.cache(this, cb);
                }
            }
        }
        return cb;
    }

    @Override
    public Writer openWriter() throws IOException {
        this.fileManager.flushCache(this);
        this.ensureParentDirectoriesExist();
        return new OutputStreamWriter(Files.newOutputStream(this.file, new OpenOption[0]), this.fileManager.getEncodingName());
    }

    @Override
    public long getLastModified() {
        try {
            return Files.getLastModifiedTime(this.file, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public boolean delete() {
        try {
            Files.delete(this.file);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    protected CharsetDecoder getDecoder(boolean ignoreEncodingErrors) {
        return this.fileManager.getDecoder(this.fileManager.getEncodingName(), ignoreEncodingErrors);
    }

    @Override
    protected String inferBinaryName(Iterable<? extends Path> path) {
        String fPath = this.file.toString();
        for (Path path2 : path) {
            String sep = path2.getFileSystem().getSeparator();
            String dPath = path2.toString();
            if (dPath.length() == 0) {
                dPath = System.getProperty("user.dir");
            }
            if (!dPath.endsWith(sep)) {
                dPath = dPath + sep;
            }
            if (!fPath.regionMatches(true, 0, dPath, 0, dPath.length()) || !Paths.get(fPath.substring(0, dPath.length()), new String[0]).equals(Paths.get(dPath, new String[0]))) continue;
            String relativeName = fPath.substring(dPath.length());
            return RegularFileObject.removeExtension(relativeName).replace(sep, ".");
        }
        return null;
    }

    @Override
    public boolean isNameCompatible(String cn, JavaFileObject.Kind kind) {
        String normName;
        Objects.requireNonNull(cn);
        if (kind == JavaFileObject.Kind.OTHER && this.getKind() != kind) {
            return false;
        }
        String n = cn + kind.extension;
        if (this.name.equals(n)) {
            return true;
        }
        if (isMacOS && Normalizer.isNormalized(this.name, Normalizer.Form.NFD) && Normalizer.isNormalized(n, Normalizer.Form.NFC) && (normName = Normalizer.normalize(this.name, Normalizer.Form.NFC)).equals(n)) {
            this.name = normName;
            return true;
        }
        if (this.name.equalsIgnoreCase(n)) {
            try {
                return this.file.toRealPath(new LinkOption[0]).getFileName().toString().equals(n);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    private void ensureParentDirectoriesExist() throws IOException {
        if (!this.hasParents) {
            Path parent = this.file.getParent();
            if (parent != null && !Files.isDirectory(parent, new LinkOption[0])) {
                try {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new IOException("could not create parent directories", e);
                }
            }
            this.hasParents = true;
        }
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RegularFileObject)) {
            return false;
        }
        RegularFileObject o = (RegularFileObject)other;
        return this.getAbsoluteFile().equals(o.getAbsoluteFile());
    }

    @Override
    public int hashCode() {
        return this.getAbsoluteFile().hashCode();
    }

    private Path getAbsoluteFile() {
        Path absFile;
        Path path = absFile = this.absFileRef == null ? null : this.absFileRef.get();
        if (absFile == null) {
            absFile = this.file.toAbsolutePath();
            this.absFileRef = new SoftReference<Path>(absFile);
        }
        return absFile;
    }
}

