/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.builds;

import java.io.IOException;
import org.netbeans.modules.cnd.execution.ExecutionSupport;
import org.openide.filesystems.FileObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public class CMakeExecSupport
extends ExecutionSupport {
    private Sheet.Set sheetSet;
    private static final String PROP_CMAKE_COMMAND = "cmakeCommand";
    private static final String PROP_RUN_DIRECTORY = "rundirectory";
    private static final String PROP_ENVIRONMENT = "environment";
    private PropertySupport<String> cmakeRunDirectory;
    private PropertySupport<String> cmakeCommandProperty;
    private PropertySupport<String> cmakeEnvironmentProperty;

    public CMakeExecSupport(MultiDataObject.Entry entry) {
        super(entry);
    }

    public FileObject getFileObject() {
        return this.getEntry().getFile();
    }

    private void createProperties() {
        if (this.cmakeCommandProperty == null) {
            this.cmakeCommandProperty = this.createQMakeCommandProperty();
            this.cmakeRunDirectory = this.createRunDirectoryProperty();
            this.cmakeEnvironmentProperty = this.createEnvironmentProperty(PROP_ENVIRONMENT, CMakeExecSupport.getString("PROP_CMAKE_ENVIRONMENT"), CMakeExecSupport.getString("HINT_CMAKE_ENVIRONMENT"));
        }
    }

    @Override
    public void addProperties(Sheet.Set set) {
        this.createProperties();
        this.sheetSet = set;
        set.put(this.createParamsProperty("params", CMakeExecSupport.getString("PROP_QMAKE_PARAMS"), CMakeExecSupport.getString("HINT_QMAKE_PARAMS")));
        set.put(this.cmakeRunDirectory);
        set.put(this.cmakeCommandProperty);
        set.put(this.cmakeEnvironmentProperty);
    }

    private PropertySupport<String> createQMakeCommandProperty() {
        PropertySupport.ReadWrite<String> result = new PropertySupport.ReadWrite<String>(PROP_CMAKE_COMMAND, String.class, CMakeExecSupport.getString("PROP_CMAKE_COMMAND"), CMakeExecSupport.getString("HINT_CMAKE_COMMAND")){

            public String getValue() {
                return CMakeExecSupport.this.getCMakeCommand();
            }

            public void setValue(String val) {
                CMakeExecSupport.this.setCMakeCommand(val);
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() {
                this.setValue(null);
            }

            public boolean canWrite() {
                return CMakeExecSupport.this.getEntry().getFile().getParent().canWrite();
            }
        };
        result.setValue("oneline", (Object)Boolean.TRUE);
        return result;
    }

    public String getCMakeCommand() {
        String make = (String)this.getEntry().getFile().getAttribute(PROP_CMAKE_COMMAND);
        if (make == null || make.equals("")) {
            make = "cmake";
            this.setCMakeCommand(make);
        }
        return make;
    }

    public void setCMakeCommand(String make) {
        block2: {
            try {
                this.getEntry().getFile().setAttribute(PROP_CMAKE_COMMAND, (Object)make);
            }
            catch (IOException ex) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block2;
                ex.printStackTrace();
            }
        }
    }

    private PropertySupport<String> createRunDirectoryProperty() {
        PropertySupport.ReadWrite<String> result = new PropertySupport.ReadWrite<String>(PROP_RUN_DIRECTORY, String.class, CMakeExecSupport.getString("PROP_RUN_CMAKE_DIRECTORY"), CMakeExecSupport.getString("HINT_RUN_CMAKE_DIRECTORY")){

            public String getValue() {
                return CMakeExecSupport.this.getRunDirectory();
            }

            public void setValue(String val) {
                CMakeExecSupport.this.setRunDirectory(val);
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() {
                this.setValue(null);
            }

            public boolean canWrite() {
                return CMakeExecSupport.this.getEntry().getFile().getParent().canWrite();
            }
        };
        result.setValue("oneline", (Object)Boolean.TRUE);
        return result;
    }

    public String getRunDirectory() {
        String dir = (String)this.getEntry().getFile().getAttribute(PROP_RUN_DIRECTORY);
        if (dir == null) {
            dir = ".";
            this.setRunDirectory(dir);
        }
        return dir;
    }

    public void setRunDirectory(String dir) {
        block2: {
            FileObject fo = this.getEntry().getFile();
            try {
                fo.setAttribute(PROP_RUN_DIRECTORY, (Object)dir);
            }
            catch (IOException ex) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block2;
                ex.printStackTrace();
            }
        }
    }

    private static String getString(String key) {
        return NbBundle.getBundle(CMakeExecSupport.class).getString(key);
    }
}

