/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.hints;

import com.oracle.js.parser.TokenType;
import com.oracle.js.parser.ir.BinaryNode;
import com.oracle.js.parser.ir.ClassNode;
import com.oracle.js.parser.ir.ExportNode;
import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.FunctionNode;
import com.oracle.js.parser.ir.IdentNode;
import com.oracle.js.parser.ir.PropertyNode;
import com.oracle.js.parser.ir.UnaryNode;
import com.oracle.js.parser.ir.VarNode;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.javascript2.editor.JsPreferences;
import org.netbeans.modules.javascript2.editor.JsVersion;
import org.netbeans.modules.javascript2.editor.hints.Bundle;
import org.netbeans.modules.javascript2.editor.hints.EcmaLevelRule;
import org.netbeans.modules.javascript2.editor.hints.JsHintsProvider;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.javascript2.lexer.api.LexUtilities;
import org.netbeans.modules.javascript2.model.api.ModelUtils;
import org.netbeans.modules.javascript2.model.spi.PathNodeVisitor;
import org.netbeans.modules.javascript2.types.spi.ParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

public class Ecma7Rule
extends EcmaLevelRule {
    private static RequestProcessor RP = new RequestProcessor(Ecma7Rule.class);

    @Override
    void computeHints(JsHintsProvider.JsRuleContext context, List<Hint> hints, int offset, HintsProvider.HintsManager manager) throws BadLocationException {
        if (JsPreferences.isPreECMAScript7(FileOwnerQuery.getOwner((FileObject)context.getJsParserResult().getSnapshot().getSource().getFileObject()))) {
            Ecma7Visitor visitor = new Ecma7Visitor();
            visitor.process(context, hints);
        }
    }

    private void addHint(JsHintsProvider.JsRuleContext context, List<Hint> hints, OffsetRange range) {
        this.addDocumenHint(context, hints, ModelUtils.documentOffsetRange((ParserResult)context.getJsParserResult(), (int)range.getStart(), (int)range.getEnd()));
    }

    private void addDocumenHint(JsHintsProvider.JsRuleContext context, List<Hint> hints, OffsetRange range) {
        hints.add(new Hint((Rule)this, Bundle.Ecma7Desc(), context.getJsParserResult().getSnapshot().getSource().getFileObject(), range, Collections.singletonList(new SwitchToEcma7Fix(context.getJsParserResult().getSnapshot())), 600));
    }

    public Set<?> getKinds() {
        return Collections.singleton("js.other.hints");
    }

    public String getId() {
        return "ecma7.hint";
    }

    public String getDescription() {
        return Bundle.Ecma7Desc();
    }

    public String getDisplayName() {
        return Bundle.Ecma7DisplayName();
    }

    private static final class SwitchToEcma7Fix
    implements HintFix {
        private final FileObject fo;

        public SwitchToEcma7Fix(Snapshot snapshot) {
            this.fo = snapshot.getSource().getFileObject();
        }

        public String getDescription() {
            return Bundle.MSG_SwitchToEcma7();
        }

        public void implement() throws Exception {
            if (this.fo == null) {
                return;
            }
            Project p = FileOwnerQuery.getOwner((FileObject)this.fo);
            if (p != null) {
                JsPreferences.putECMAScriptVersion(p, JsVersion.ECMA7);
            }
            EcmaLevelRule.refresh(this.fo);
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private class Ecma7Visitor
    extends PathNodeVisitor {
        private List<Hint> hints;
        private JsHintsProvider.JsRuleContext context;

        private Ecma7Visitor() {
        }

        public void process(JsHintsProvider.JsRuleContext context, List<Hint> hints) {
            this.hints = hints;
            this.context = context;
            FunctionNode root = context.getJsParserResult().getRoot();
            if (root != null) {
                context.getJsParserResult().getRoot().accept((NodeVisitor)this);
            }
        }

        public boolean enterFunctionNode(FunctionNode functionNode) {
            List params;
            if (functionNode.isModule()) {
                functionNode.visitExports((NodeVisitor)this);
            }
            if (functionNode.isAsync()) {
                Ecma7Rule.this.addHint(this.context, this.hints, new OffsetRange(com.oracle.js.parser.Token.descPosition((long)functionNode.getFirstToken()), functionNode.getStart()));
            }
            if ((params = functionNode.getParameters()) != null && !params.isEmpty()) {
                IdentNode last = (IdentNode)params.get(params.size() - 1);
                this.checkTrailingComma(last.getFinish());
            }
            return super.enterFunctionNode(functionNode);
        }

        public boolean enterExportNode(ExportNode exportNode) {
            if (exportNode.isDefault()) {
                return super.enterExportNode(exportNode);
            }
            return false;
        }

        public boolean enterVarNode(VarNode varNode) {
            if (varNode.isExport() || varNode.isDestructuring()) {
                return false;
            }
            return super.enterVarNode(varNode);
        }

        public boolean enterClassNode(ClassNode classNode) {
            for (Expression decorator : classNode.getDecorators()) {
                Ecma7Rule.this.addHint(this.context, this.hints, new OffsetRange(decorator.getStart(), decorator.getFinish()));
            }
            return super.enterClassNode(classNode);
        }

        public boolean enterPropertyNode(PropertyNode propertyNode) {
            for (Expression decorator : propertyNode.getDecorators()) {
                Ecma7Rule.this.addHint(this.context, this.hints, new OffsetRange(decorator.getStart(), decorator.getFinish()));
            }
            Expression key = propertyNode.getKey();
            if (key.isTokenType(TokenType.SPREAD_OBJECT)) {
                long token = key.getToken();
                int position = com.oracle.js.parser.Token.descPosition((long)token);
                Ecma7Rule.this.addHint(this.context, this.hints, new OffsetRange(position, position + com.oracle.js.parser.Token.descLength((long)token)));
                key.accept((NodeVisitor)this);
                return false;
            }
            return super.enterPropertyNode(propertyNode);
        }

        public boolean enterBinaryNode(BinaryNode binaryNode) {
            Expression rhs;
            long token = binaryNode.getToken();
            TokenType type = com.oracle.js.parser.Token.descType((long)token);
            if (TokenType.ASSIGN_EXP == type || TokenType.EXP == type) {
                int position = com.oracle.js.parser.Token.descPosition((long)token);
                Ecma7Rule.this.addHint(this.context, this.hints, new OffsetRange(position, position + com.oracle.js.parser.Token.descLength((long)token)));
            } else if (TokenType.COMMARIGHT == type && !(rhs = binaryNode.rhs()).isTokenType(TokenType.COMMARIGHT)) {
                this.checkTrailingComma(rhs.getFinish());
            }
            return super.enterBinaryNode(binaryNode);
        }

        public boolean enterUnaryNode(UnaryNode unaryNode) {
            if (unaryNode.isTokenType(TokenType.AWAIT)) {
                long token = unaryNode.getToken();
                int position = com.oracle.js.parser.Token.descPosition((long)token);
                Ecma7Rule.this.addHint(this.context, this.hints, new OffsetRange(position, position + com.oracle.js.parser.Token.descLength((long)token)));
            }
            return super.enterUnaryNode(unaryNode);
        }

        private void checkTrailingComma(int offset) {
            Token next;
            TokenSequence ts;
            int fileOffset = this.context.parserResult.getSnapshot().getOriginalOffset(offset);
            if (fileOffset >= 0 && (ts = LexUtilities.getPositionedSequence((Snapshot)this.context.parserResult.getSnapshot(), (int)offset, (Language)JsTokenId.javascriptLanguage())) != null && (next = LexUtilities.findNextNonWsNonComment((TokenSequence)ts)) != null && next.id() == JsTokenId.OPERATOR_COMMA) {
                Ecma7Rule.this.addDocumenHint(this.context, this.hints, new OffsetRange(ts.offset(), ts.offset() + next.length()));
            }
        }
    }
}

