/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.ui;

import java.io.PrintWriter;
import java.util.ArrayList;
import org.netbeans.modules.remote.ui.FsTests;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class FsTestActions {
    private static final TestPerfAction TEST_PERF_ACTION = new TestPerfAction();
    private static final boolean TEST = Boolean.getBoolean("cnd.remote.test.perf");

    private FsTestActions() {
    }

    public static ContextAwareAction add() {
        return TEST_PERF_ACTION;
    }

    private static class TestPerfAction
    extends NodeAction {
        static final long serialVersionUID = -6471281373153172312L;

        public TestPerfAction() {
            this.putValue("noIconInMenu", Boolean.TRUE);
        }

        public boolean enable(Node[] arr) {
            if (!TEST || arr == null || arr.length == 0) {
                return false;
            }
            for (int i = 0; i < arr.length; ++i) {
                DataObject dataObject = (DataObject)arr[i].getCookie(DataObject.class);
                if (this.isAllowed(dataObject)) continue;
                return false;
            }
            return true;
        }

        private boolean isAllowed(DataObject dataObject) {
            return dataObject != null && dataObject.getPrimaryFile().isFolder();
        }

        public String getName() {
            return NbBundle.getMessage(FsTestActions.class, (String)"ActionTestPerf");
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        protected void performAction(Node[] activatedNodes) {
            if (activatedNodes == null) {
                return;
            }
            ArrayList<FileObject> fileObjects = new ArrayList<FileObject>();
            for (Node node : activatedNodes) {
                FileObject fo = (FileObject)node.getLookup().lookup(FileObject.class);
                if (fo == null) continue;
                fileObjects.add(fo);
            }
            if (fileObjects.size() > 0) {
                StringBuilder title = new StringBuilder("PERFTEST ");
                title.append(((FileObject)fileObjects.get(0)).getPath());
                if (fileObjects.size() > 1) {
                    title.append("...");
                }
                InputOutput io = IOProvider.getDefault().getIO(title.toString(), true);
                FsTests.testLs(fileObjects, (PrintWriter)io.getOut(), (PrintWriter)io.getOut());
            }
        }
    }
}

