/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.ui;

import java.awt.Image;
import java.util.List;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolsCacheManager;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.ui.AddToolchainAction;
import org.netbeans.modules.remote.ui.RemoveToolchainAction;
import org.netbeans.modules.remote.ui.RestoreToolchainsAction;
import org.netbeans.modules.remote.ui.SetDefaultToolchainAction;
import org.netbeans.modules.remote.ui.ShowToolchainsAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;

public class ToolchainListRootNode
extends AbstractNode {
    private final ExecutionEnvironment env;

    public ToolchainListRootNode(ExecutionEnvironment execEnv) {
        super(Children.create((ChildFactory)new ToolchainListChildren(execEnv), (boolean)true), Lookups.singleton((Object)execEnv));
        this.env = execEnv;
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"org/netbeans/modules/remote/ui/tools_collection.gif");
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public String getDisplayName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"LBL_ToolchainRootNode");
    }

    public Action[] getActions(boolean context) {
        return new Action[]{new AddToolchainAction(this.env), new RestoreToolchainsAction(this.env), new ShowToolchainsAction(this.env, null)};
    }

    private static class ToolNode
    extends AbstractNode {
        private final ExecutionEnvironment env;
        private final Tool tool;

        public ToolNode(ExecutionEnvironment env, Tool tool) {
            super(Children.LEAF, Lookups.fixed((Object[])new Object[]{env, tool}));
            this.env = env;
            this.tool = tool;
        }

        public String getDisplayName() {
            return this.tool.getDisplayName() + '[' + this.tool.getPath() + ']';
        }

        public String getHtmlDisplayName() {
            return this.tool.getDisplayName() + "  <font color='!textInactiveText'> [" + this.tool.getPath() + ']';
        }

        public Image getIcon(int type) {
            return ImageUtilities.loadImage((String)"org/netbeans/modules/remote/ui/tool.png");
        }

        public String getShortDescription() {
            return this.tool.getPath();
        }

        public Action[] getActions(boolean context) {
            return new Action[0];
        }
    }

    private static class ToolChildren
    extends ChildFactory<Tool> {
        private final ExecutionEnvironment env;
        private final CompilerSet compilerSet;

        public ToolChildren(ExecutionEnvironment env, CompilerSet compilerSet) {
            this.env = env;
            this.compilerSet = compilerSet;
        }

        protected boolean createKeys(List<Tool> toPopulate) {
            if (!this.compilerSet.getName().equals("None")) {
                for (Tool tool : this.compilerSet.getTools()) {
                    if (tool.getPath().isEmpty()) continue;
                    toPopulate.add(tool);
                }
            }
            return true;
        }

        protected Node createNodeForKey(Tool key) {
            return new ToolNode(this.env, key);
        }
    }

    private static class ToolchainNode
    extends AbstractNode {
        private final ExecutionEnvironment env;
        private final CompilerSet compilerSet;

        public ToolchainNode(ExecutionEnvironment env, CompilerSet compilerSet) {
            super(Children.create((ChildFactory)new ToolChildren(env, compilerSet), (boolean)true), Lookups.fixed((Object[])new Object[]{env, compilerSet}));
            this.env = env;
            this.compilerSet = compilerSet;
        }

        public String getHtmlDisplayName() {
            String displayName = this.getDisplayName();
            if (CompilerSetManager.get((ExecutionEnvironment)this.env).isDefaultCompilerSet(this.compilerSet)) {
                displayName = "<b>" + displayName + "</b>";
            }
            return displayName;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(ToolchainListRootNode.class, (String)"Toolchain_Name_Text", (Object)this.compilerSet.getName(), (Object)this.compilerSet.getDisplayName());
        }

        public Image getIcon(int type) {
            return ImageUtilities.loadImage((String)"org/netbeans/modules/remote/ui/tools_collection.gif");
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public Action[] getActions(boolean context) {
            if (this.compilerSet.getName().equals("None")) {
                return new Action[]{new ShowToolchainsAction(this.env, this.compilerSet)};
            }
            return new Action[]{new ShowToolchainsAction(this.env, this.compilerSet), new SetDefaultToolchainAction(this.env, this.compilerSet), new RemoveToolchainAction(this.env, this.compilerSet)};
        }
    }

    static class ToolchainListChildren
    extends ChildFactory<CompilerSet>
    implements ChangeListener {
        private final ExecutionEnvironment env;

        public ToolchainListChildren(ExecutionEnvironment env) {
            this.env = env;
            ToolsCacheManager.addChangeListener((ChangeListener)WeakListeners.change((ChangeListener)this, null));
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.refresh(false);
        }

        protected boolean createKeys(List<CompilerSet> toPopulate) {
            toPopulate.addAll(CompilerSetManager.get((ExecutionEnvironment)this.env).getCompilerSets());
            return true;
        }

        protected Node createNodeForKey(CompilerSet key) {
            return new ToolchainNode(this.env, key);
        }
    }
}

