/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.config;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.spi.MessageDestinationDeployment;
import org.netbeans.modules.j2ee.jboss4.config.JB7MessageDestinationHandler;
import org.netbeans.modules.j2ee.jboss4.config.JBossDatasourceManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class JBossMessageDestinationManager
implements MessageDestinationDeployment {
    private static final Logger LOGGER = Logger.getLogger(JBossMessageDestinationManager.class.getName());
    private final FileObject serverDir;
    private final boolean isAs7;

    public JBossMessageDestinationManager(String serverUrl, boolean isAs7) {
        String serverDirPath = InstanceProperties.getInstanceProperties((String)serverUrl).getProperty("server-dir");
        this.serverDir = FileUtil.toFileObject((File)new File(serverDirPath));
        this.isAs7 = isAs7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<MessageDestination> getMessageDestinations() throws ConfigurationException {
        HashSet<MessageDestination> messageDestinations = new HashSet<MessageDestination>();
        if (this.isAs7) {
            FileObject config = this.serverDir.getFileObject("configuration/standalone.xml");
            if (config == null) {
                config = this.serverDir.getFileObject("configuration/domain.xml");
            }
            if (config == null || !config.isData()) {
                LOGGER.log(Level.WARNING, NbBundle.getMessage(JBossDatasourceManager.class, (String)"ERR_WRONG_JMS_CONFIG_FILE"));
                return messageDestinations;
            }
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser parser = factory.newSAXParser();
                JB7MessageDestinationHandler handler = new JB7MessageDestinationHandler();
                BufferedInputStream is = new BufferedInputStream(config.getInputStream());
                try {
                    parser.parse((InputStream)is, (DefaultHandler)handler);
                }
                finally {
                    ((InputStream)is).close();
                }
                messageDestinations.addAll(handler.getMessageDestinations());
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, NbBundle.getMessage(JBossDatasourceManager.class, (String)"ERR_WRONG_JMS_CONFIG_FILE"), ex);
            }
            catch (SAXException ex) {
                LOGGER.log(Level.WARNING, NbBundle.getMessage(JBossDatasourceManager.class, (String)"ERR_WRONG_JMS_CONFIG_FILE"), ex);
            }
            catch (ParserConfigurationException ex) {
                LOGGER.log(Level.WARNING, NbBundle.getMessage(JBossDatasourceManager.class, (String)"ERR_WRONG_JMS_CONFIG_FILE"), ex);
            }
            return messageDestinations;
        }
        return messageDestinations;
    }

    public void deployMessageDestinations(Set<MessageDestination> destinations) throws ConfigurationException {
    }
}

