/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.search.util;

import java.io.IOException;
import java.util.List;
import org.netbeans.api.search.SearchRoot;
import org.netbeans.api.search.provider.SearchInfo;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileObject;

public class SearchScopeValidator {
    private HostInfo.OSFamily localhostOSFamily;

    public SearchScopeValidator() {
        ExecutionEnvironment local = ExecutionEnvironmentFactory.getLocal();
        if (HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)local)) {
            try {
                this.localhostOSFamily = HostInfoUtils.getHostInfo((ExecutionEnvironment)local).getOSFamily();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isSearchAllowed(SearchInfo searchInfo) {
        try {
            if (searchInfo == null) {
                return false;
            }
            List searchRoots = searchInfo.getSearchRoots();
            for (SearchRoot searchRoot : searchRoots) {
                ExecutionEnvironment env = FileSystemProvider.getExecutionEnvironment((FileObject)searchRoot.getFileObject());
                if (!(env.isLocal() ? this.localhostOSFamily == null || !this.localhostOSFamily.isUnix() : HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)env) && !HostInfoUtils.getHostInfo((ExecutionEnvironment)env).getOSFamily().isUnix())) continue;
                return false;
            }
        }
        catch (IOException ex) {
            return false;
        }
        catch (ConnectionManager.CancellationException ex) {
            return false;
        }
        return true;
    }
}

