/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.impl.web.annotation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.j2ee.dd.impl.web.annotation.Refreshable;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObject;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.AnnotationParser;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ArrayValueHandler;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ParseResult;

public class WebServlet
extends PersistentObject
implements Refreshable {
    private String name;
    private List<String> urlPatterns = new ArrayList<String>();
    private String clazz;

    public WebServlet(AnnotationModelHelper helper, TypeElement typeElement) {
        super(helper, typeElement);
        boolean valid = this.refresh(typeElement);
        assert (valid);
    }

    @Override
    public boolean refresh(TypeElement typeElement) {
        Map annByType = this.getHelper().getAnnotationsByType(typeElement.getAnnotationMirrors());
        AnnotationMirror annotationMirror = (AnnotationMirror)annByType.get("javax.servlet.annotation.WebServlet");
        if (annotationMirror == null) {
            return false;
        }
        AnnotationParser parser = AnnotationParser.create((AnnotationModelHelper)this.getHelper());
        parser.expectString("name", AnnotationParser.defaultValue((Object)typeElement.getSimpleName().toString()));
        this.urlPatterns.clear();
        parser.expectStringArray("urlPatterns", new ArrayValueHandler(){

            public Object handleArray(List<AnnotationValue> arrayMembers) {
                for (AnnotationValue arrayMember : arrayMembers) {
                    String value = (String)arrayMember.getValue();
                    WebServlet.this.urlPatterns.add(value);
                }
                return null;
            }
        }, null);
        parser.expectStringArray("value", new ArrayValueHandler(){

            public Object handleArray(List<AnnotationValue> arrayMembers) {
                for (AnnotationValue arrayMember : arrayMembers) {
                    String value = (String)arrayMember.getValue();
                    WebServlet.this.urlPatterns.add(value);
                }
                return null;
            }
        }, null);
        ParseResult parseResult = parser.parse(annotationMirror);
        this.name = (String)parseResult.get("name", String.class);
        this.clazz = typeElement.getQualifiedName().toString();
        return true;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getUrlPatterns() {
        return this.urlPatterns;
    }

    public String getServletClass() {
        return this.clazz;
    }
}

