/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.support;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.openide.util.Lookup;

public abstract class CsmClassifierResolver {
    private static final CsmClassifierResolver DEFAULT = new Default();

    public abstract CsmClassifier getOriginalClassifier(CsmClassifier var1, CsmFile var2);

    @Deprecated
    public abstract CsmClassifier getTypeClassifier(CsmType var1, CsmFile var2, int var3, boolean var4);

    public abstract CsmClassifier getTypeClassifier(CsmType var1, CsmScope var2, CsmFile var3, int var4, boolean var5);

    public CsmClassifier findClassifierUsedInFile(CharSequence qualifiedName, CsmFile csmFile, boolean classesOnly) {
        CsmProject project;
        if (csmFile != null && (project = csmFile.getProject()) != null) {
            return project.findClassifier(qualifiedName);
        }
        return null;
    }

    public boolean isForwardClassifier(CsmObject obj) {
        return this.isForwardClass(obj) || this.isForwardEnum(obj);
    }

    public abstract boolean isForwardClass(CsmObject var1);

    public abstract boolean isForwardEnum(CsmObject var1);

    protected CsmClassifierResolver() {
    }

    public static CsmClassifierResolver getDefault() {
        return DEFAULT;
    }

    private static final class Default
    extends CsmClassifierResolver {
        private final Lookup.Result<CsmClassifierResolver> res = Lookup.getDefault().lookupResult(CsmClassifierResolver.class);
        private static final boolean FIX_SERVICE = true;
        private CsmClassifierResolver fixedResolver;
        private static final ThreadLocal<Set<TypeResolveRequest>> threadLocalTypeAntiloopSet = new ThreadLocal<Set<TypeResolveRequest>>(){

            @Override
            protected Set<TypeResolveRequest> initialValue() {
                return new HashSet<TypeResolveRequest>();
            }
        };
        private static final ThreadLocal<Set<ClassifierResolveRequest>> threadLocalClassifierAntiloopSet = new ThreadLocal<Set<ClassifierResolveRequest>>(){

            @Override
            protected Set<ClassifierResolveRequest> initialValue() {
                return new HashSet<ClassifierResolveRequest>();
            }
        };

        Default() {
        }

        private CsmClassifierResolver getService() {
            CsmClassifierResolver service = this.fixedResolver;
            if (service == null) {
                Iterator iterator = this.res.allInstances().iterator();
                if (iterator.hasNext()) {
                    CsmClassifierResolver selector;
                    service = selector = (CsmClassifierResolver)iterator.next();
                }
                if (service != null) {
                    this.fixedResolver = service;
                }
            }
            return service;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CsmClassifier getOriginalClassifier(CsmClassifier orig, CsmFile contextFile) {
            ClassifierResolveRequest request = new ClassifierResolveRequest(orig, contextFile);
            if (Default.enterAntiloop(threadLocalClassifierAntiloopSet.get(), request)) {
                try {
                    CsmClassifierResolver service = this.getService();
                    if (service != null) {
                        CsmClassifier csmClassifier = service.getOriginalClassifier(orig, contextFile);
                        return csmClassifier;
                    }
                }
                finally {
                    Default.exitAntiloop(threadLocalClassifierAntiloopSet.get(), request);
                }
            }
            return orig;
        }

        @Override
        public CsmClassifier getTypeClassifier(CsmType type, CsmFile contextFile, int contextOffset, boolean resolveTypeChain) {
            return this.getTypeClassifier(type, null, contextFile, contextOffset, resolveTypeChain);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CsmClassifier getTypeClassifier(CsmType type, CsmScope contextScope, CsmFile contextFile, int contextOffset, boolean resolveTypeChain) {
            CsmClassifier classifier = null;
            TypeResolveRequest request = new TypeResolveRequest(type, contextFile, contextOffset);
            if (Default.enterAntiloop(threadLocalTypeAntiloopSet.get(), request)) {
                try {
                    CsmClassifierResolver service = this.getService();
                    if (service != null) {
                        CsmClassifier csmClassifier = service.getTypeClassifier(type, contextScope, contextFile, contextOffset, resolveTypeChain);
                        return csmClassifier;
                    }
                    classifier = type.getClassifier();
                    if (resolveTypeChain) {
                        classifier = this.getOriginalClassifier(classifier, contextFile);
                    }
                }
                finally {
                    Default.exitAntiloop(threadLocalTypeAntiloopSet.get(), request);
                }
            }
            return classifier;
        }

        @Override
        public CsmClassifier findClassifierUsedInFile(CharSequence qualifiedName, CsmFile csmFile, boolean classesOnly) {
            CsmClassifierResolver service = this.getService();
            if (service != null) {
                return service.findClassifierUsedInFile(qualifiedName, csmFile, classesOnly);
            }
            return super.findClassifierUsedInFile(qualifiedName, csmFile, classesOnly);
        }

        @Override
        public boolean isForwardClass(CsmObject cls) {
            CsmClassifierResolver service = this.getService();
            if (service != null) {
                return service.isForwardClass(cls);
            }
            return false;
        }

        @Override
        public boolean isForwardEnum(CsmObject cls) {
            CsmClassifierResolver service = this.getService();
            if (service != null) {
                return service.isForwardEnum(cls);
            }
            return false;
        }

        private static <T> boolean enterAntiloop(Set<T> antiloop, T request) {
            if (antiloop.contains(request)) {
                return false;
            }
            antiloop.add(request);
            return true;
        }

        private static <T> void exitAntiloop(Set<T> antiloop, T request) {
            antiloop.remove(request);
        }

        private static class ClassifierResolveRequest {
            private final CsmClassifier cls;
            private final CsmFile contextFile;

            public ClassifierResolveRequest(CsmClassifier cls, CsmFile contextFile) {
                this.cls = cls;
                this.contextFile = contextFile;
            }

            public int hashCode() {
                int hash = 5;
                hash = 17 * hash + (this.cls != null ? this.cls.hashCode() : 0);
                hash = 17 * hash + (this.contextFile != null ? this.contextFile.hashCode() : 0);
                return hash;
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                ClassifierResolveRequest other = (ClassifierResolveRequest)obj;
                if (!(this.cls == other.cls || this.cls != null && this.cls.equals(other.cls))) {
                    return false;
                }
                return this.contextFile == other.contextFile || this.contextFile != null && this.contextFile.equals(other.contextFile);
            }
        }

        private static class TypeResolveRequest {
            private final CsmType type;
            private final CsmFile contextFile;
            private final int offset;

            public TypeResolveRequest(CsmType type, CsmFile contextFile, int offset) {
                this.type = type;
                this.contextFile = contextFile;
                this.offset = offset;
            }

            public int hashCode() {
                int hash = 7;
                hash = 67 * hash + (this.contextFile != null ? this.contextFile.hashCode() : 0);
                hash = 67 * hash + this.offset;
                return hash;
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                TypeResolveRequest other = (TypeResolveRequest)obj;
                if (!(this.type == other.type || this.type != null && this.type.equals(other.type))) {
                    return false;
                }
                if (!(this.contextFile == other.contextFile || this.contextFile != null && this.contextFile.equals(other.contextFile))) {
                    return false;
                }
                return this.offset == other.offset;
            }
        }
    }
}

