/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.metro.samples;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.websvc.wsitconf.api.DevDefaultsProvider;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WebSampleProjectGenerator {
    private static final String DEFAULT_PORT = "8080";
    private static final String LOCALHOST = "localhost";
    public static final String PROJECT_CONFIGURATION_NAMESPACE = "http://www.netbeans.org/ns/web-project/3";
    public static final String JSPC_CLASSPATH = "jspc.classpath";

    private WebSampleProjectGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<FileObject> createProjectFromTemplate(FileObject template, File projectLocation, String name, String serverID) throws IOException {
        assert (template != null && projectLocation != null && name != null);
        ArrayList<FileObject> projects = new ArrayList<FileObject>();
        if (template.getExt().endsWith("zip")) {
            FileObject prjLoc = WebSampleProjectGenerator.createProjectFolder(projectLocation);
            InputStream is = template.getInputStream();
            try {
                WebSampleProjectGenerator.unzip(is, prjLoc);
                projects.add(prjLoc);
                File projXml = FileUtil.toFile((FileObject)prjLoc.getFileObject("nbproject/project.xml"));
                Document doc = XMLUtil.parse((InputSource)new InputSource(projXml.toURI().toString()), (boolean)false, (boolean)true, null, null);
                NodeList nlist = doc.getElementsByTagNameNS(PROJECT_CONFIGURATION_NAMESPACE, "name");
                if (nlist != null) {
                    for (int i = 0; i < nlist.getLength(); ++i) {
                        Node n = nlist.item(i);
                        if (n.getNodeType() != 1) continue;
                        Element e = (Element)n;
                        WebSampleProjectGenerator.replaceText(e, name);
                    }
                    WebSampleProjectGenerator.saveXml(doc, prjLoc, "nbproject/project.xml");
                    WebSampleProjectGenerator.updateServerReference(prjLoc, serverID);
                }
            }
            catch (Exception e) {
                throw new IOException(e.toString());
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
            prjLoc.refresh(false);
        } else {
            String files = (String)template.getAttribute("files");
            if (files != null && files.length() > 0) {
                StringTokenizer st = new StringTokenizer(files, ",");
                while (st.hasMoreElements()) {
                    String prjName = st.nextToken();
                    if (prjName == null || prjName.trim().equals("")) continue;
                    InputStream is = WebSampleProjectGenerator.class.getResourceAsStream(prjName);
                    try {
                        FileObject prjLoc = WebSampleProjectGenerator.createProjectFolder(new File(projectLocation, prjName.substring(prjName.lastIndexOf("/") + 1, prjName.indexOf(46))));
                        WebSampleProjectGenerator.unzip(is, prjLoc);
                        WebSampleProjectGenerator.updateServerReference(prjLoc, serverID);
                        projects.add(prjLoc);
                        Boolean needsDefaults = (Boolean)template.getAttribute("needsdefaults");
                        if (!needsDefaults.booleanValue()) continue;
                        DevDefaultsProvider.getDefault().fillDefaultsToServer(serverID);
                    }
                    catch (Exception e) {
                        Exceptions.printStackTrace((Throwable)e);
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                }
            }
        }
        return projects;
    }

    private static void updateServerReference(FileObject fileObject, String serverID) throws IOException, InstanceRemovedException, SAXException {
        ServerInstance serverInstance = Deployment.getDefault().getServerInstance(serverID);
        if (serverInstance == null) {
            return;
        }
        ServerInstance.Descriptor descriptor = serverInstance.getDescriptor();
        if (descriptor == null) {
            return;
        }
        String host = descriptor.getHostname();
        int port = descriptor.getHttpPort();
        if (fileObject.isFolder()) {
            FileObject[] files;
            for (FileObject file : files = fileObject.getChildren()) {
                WebSampleProjectGenerator.updateServerReference(file, serverID);
            }
        } else {
            File file;
            Document doc;
            NodeList nlist;
            String name = fileObject.getNameExt();
            if (name.endsWith("catalog.xml") && (nlist = (doc = XMLUtil.parse((InputSource)new InputSource((file = FileUtil.toFile((FileObject)fileObject)).toURI().toString()), (boolean)false, (boolean)true, null, null)).getElementsByTagName("system")) != null) {
                for (int i = 0; i < nlist.getLength(); ++i) {
                    Node node = nlist.item(i);
                    if (node.getNodeType() != 1) continue;
                    Element element = (Element)node;
                    Attr attribute = element.getAttributeNode("systemId");
                    String value = attribute.getValue();
                    if (host != null && host.length() > 0 && value.contains(LOCALHOST)) {
                        value = value.replace(LOCALHOST, host);
                    }
                    if (port != 0 && value.contains(DEFAULT_PORT)) {
                        value = value.replace(DEFAULT_PORT, "" + port);
                    }
                    attribute.setValue(value);
                }
                WebSampleProjectGenerator.saveXml(doc, fileObject.getParent(), name);
            }
        }
    }

    private static FileObject createProjectFolder(File projectFolder) throws IOException {
        FileObject projLoc;
        Stack<String> nameStack = new Stack<String>();
        while ((projLoc = FileUtil.toFileObject((File)projectFolder)) == null) {
            nameStack.push(projectFolder.getName());
            projectFolder = projectFolder.getParentFile();
        }
        while (!nameStack.empty()) {
            projLoc = projLoc.createFolder((String)nameStack.pop());
            assert (projLoc != null);
        }
        return projLoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzip(InputStream source, FileObject targetFolder) throws IOException {
        ZipInputStream zip = new ZipInputStream(source);
        try {
            ZipEntry ent;
            while ((ent = zip.getNextEntry()) != null) {
                if (ent.isDirectory()) {
                    FileUtil.createFolder((FileObject)targetFolder, (String)ent.getName());
                    continue;
                }
                FileObject destFile = FileUtil.createData((FileObject)targetFolder, (String)ent.getName());
                FileLock lock = destFile.lock();
                try {
                    OutputStream out = destFile.getOutputStream(lock);
                    try {
                        FileUtil.copy((InputStream)zip, (OutputStream)out);
                    }
                    finally {
                        out.close();
                    }
                }
                finally {
                    lock.releaseLock();
                }
            }
        }
        finally {
            zip.close();
        }
    }

    private static void replaceText(Element parent, String name) {
        NodeList l = parent.getChildNodes();
        for (int i = 0; i < l.getLength(); ++i) {
            if (l.item(i).getNodeType() != 3) continue;
            Text text = (Text)l.item(i);
            text.setNodeValue(name);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveXml(Document doc, FileObject dir, String path) throws IOException {
        FileObject xml = FileUtil.createData((FileObject)dir, (String)path);
        FileLock lock = xml.lock();
        try {
            OutputStream os = xml.getOutputStream(lock);
            try {
                XMLUtil.write((Document)doc, (OutputStream)os, (String)"UTF-8");
            }
            finally {
                os.close();
            }
        }
        finally {
            lock.releaseLock();
        }
    }
}

