/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.compilerset;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.spi.toolchain.CSMNotifier;
import org.netbeans.modules.cnd.toolchain.Installer;
import org.netbeans.modules.cnd.toolchain.compilers.SPICompilerAccesor;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerSetManagerImpl;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerSetPreferences;
import org.netbeans.modules.cnd.toolchain.support.ToolchainUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class ToolchainValidator {
    private static final boolean DISABLED = Boolean.getBoolean("cnd.toolchain.validator.disabled") || CompilerSetManagerImpl.DISABLED;
    private static final Logger LOG = Logger.getLogger(ToolchainValidator.class.getName());
    public static final ToolchainValidator INSTANCE = new ToolchainValidator();
    private static final RequestProcessor RP = new RequestProcessor("Tool collection validator", 1);

    private ToolchainValidator() {
    }

    public void validate(final ExecutionEnvironment env, final CompilerSetManagerImpl csm) {
        boolean postpone;
        if (DISABLED || Installer.isClosed()) {
            return;
        }
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ToolchainValidator.this.validateImpl(env, csm);
            }
        };
        boolean bl = postpone = env.isRemote() && !ServerList.get((ExecutionEnvironment)env).isOnline();
        if (postpone) {
            ServerList.get((ExecutionEnvironment)env).addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("stateChanged".equals(evt.getPropertyName()) && ServerList.get((ExecutionEnvironment)env).isOnline()) {
                        RP.post(runnable);
                        ServerList.get((ExecutionEnvironment)env).removePropertyChangeListener((PropertyChangeListener)this);
                    }
                }
            });
        } else {
            RP.post(runnable);
        }
    }

    public void applyChanges(Map<Tool, List<List<String>>> needReset, CompilerSetManager csm) {
        for (Map.Entry<Tool, List<List<String>>> entry : needReset.entrySet()) {
            Tool tool = entry.getKey();
            List<List<String>> compilerDefinitions = entry.getValue();
            new SPICompilerAccesor(tool).applyCompilerDefinitions(compilerDefinitions);
        }
        CompilerSetManagerImpl csmImpl = (CompilerSetManagerImpl)csm;
        CompilerSetPreferences.saveToDisk(csmImpl);
        ToolchainUtilities.fireCodeAssistanceChange(csmImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateImpl(ExecutionEnvironment env, CompilerSetManagerImpl csm) {
        if (Installer.isClosed()) {
            return;
        }
        ProgressHandle createHandle = ProgressHandle.createHandle((String)NbBundle.getMessage(ToolchainValidator.class, (String)"ToolCollectionValidation", (Object)env.getDisplayName()));
        createHandle.start();
        try {
            HashMap<Tool, List<List<String>>> needReset = new HashMap<Tool, List<List<String>>>();
            for (CompilerSet cs : csm.getCompilerSets()) {
                HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)env);
                if (hostInfo == null) {
                    LOG.log(Level.INFO, "Cannot get hostinfo for {0}", env.getDisplayName());
                    break;
                }
                for (Tool tool : cs.getTools()) {
                    List<List<String>> compilerDefinitions;
                    if (!(tool instanceof AbstractCompiler) || tool.getKind() != PredefinedToolKind.CCompiler && tool.getKind() != PredefinedToolKind.CCCompiler || this.isEqualsCompilerDefinitions(compilerDefinitions = new SPICompilerAccesor(tool).getCompilerDefinitions(), (AbstractCompiler)tool)) continue;
                    needReset.put(tool, compilerDefinitions);
                }
            }
            if (needReset.size() > 0) {
                CSMNotifier.getInstance().showNotification(needReset, csm);
            }
        }
        catch (Throwable ex) {
            LOG.log(Level.INFO, ex.getMessage());
        }
        finally {
            createHandle.finish();
        }
    }

    private boolean isEqualsCompilerDefinitions(List<List<String>> compilerDefinitions, AbstractCompiler tool) {
        if (compilerDefinitions == null) {
            return true;
        }
        List<String> systemIncludeDirectories = tool.getSystemIncludeDirectories();
        if (!this.comparePathsLists(compilerDefinitions.get(0), systemIncludeDirectories, tool)) {
            return false;
        }
        List<String> systemPreprocessorSymbols = tool.getSystemPreprocessorSymbols();
        if (!this.compareMacrosLists(compilerDefinitions.get(1), systemPreprocessorSymbols, tool)) {
            return false;
        }
        List<String> systemIncludeHeaders = tool.getSystemIncludeHeaders();
        return this.comparePathsLists(compilerDefinitions.get(2), systemIncludeHeaders, tool);
    }

    private boolean comparePathsLists(List<String> newList, List<String> oldList, AbstractCompiler tool) {
        HashSet<String> oldSet = new HashSet<String>(oldList);
        boolean res = true;
        for (String s : newList) {
            if (oldSet.contains(s)) continue;
            LOG.log(Level.FINE, "Tool {0} was changed. Added system include path {1}", new Object[]{tool.getDisplayName(), s});
            res = false;
        }
        return res;
    }

    private boolean compareMacrosLists(List<String> newList, List<String> oldList, AbstractCompiler tool) {
        HashMap<String, String> oldMap = new HashMap<String, String>();
        for (String s : oldList) {
            int i = s.indexOf(61);
            if (i > 0) {
                oldMap.put(s.substring(0, i), s.substring(i + 1));
                continue;
            }
            oldMap.put(s, null);
        }
        boolean res = true;
        for (String s : newList) {
            String value;
            String key;
            if (s.startsWith("__TIME__") || s.startsWith("__DATE__") || s.startsWith("__FILE__") || s.startsWith("__LINE__")) continue;
            int i = s.indexOf(61);
            if (i > 0) {
                key = s.substring(0, i);
                value = s.substring(i + 1);
            } else {
                key = s;
                value = null;
            }
            if (!oldMap.containsKey(key)) {
                LOG.log(Level.FINE, "Tool {0} was changed. Added macro {1}", new Object[]{tool.getDisplayName(), s});
                res = false;
            }
            String oldValue = (String)oldMap.get(key);
            if (value == null && oldValue == null || value == null && "1".equals(oldValue) || "1".equals(value) && oldValue == null || value != null && oldValue != null && value.equals(oldValue)) continue;
            LOG.log(Level.FINE, "Tool {0} was changed. Changed macro {1} from [{2}] to [{3}]", new Object[]{tool.getDisplayName(), key, oldValue, value});
            res = false;
        }
        return res;
    }
}

