/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.shell;

import com.sun.javacard.apduio.Apdu;
import com.sun.javacard.apduio.CadClientInterface;
import com.sun.javacard.apduio.CadT0Client;
import com.sun.javacard.apduio.CadT1Client;
import com.sun.javacard.apduio.CadTransportException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.javacard.shell.APDUParser;
import org.netbeans.modules.javacard.shell.ShellException;
import org.netbeans.modules.javacard.shell.ShellPanel;
import org.netbeans.modules.javacard.spi.Card;
import org.netbeans.modules.javacard.spi.capabilities.PortKind;
import org.netbeans.modules.javacard.spi.capabilities.PortProvider;
import org.netbeans.modules.javacard.spi.capabilities.UrlCapability;
import org.openide.util.NbBundle;

public class APDUSender {
    static Map<ShellPanel, APDUSender> senders = Collections.synchronizedMap(new WeakHashMap());
    private CadClientInterface contactedInterface;
    private Socket contactedSocket;
    private CadClientInterface contactlessInterface;
    private Socket contactlessSocket;
    private boolean extended;
    private boolean contactless;
    private Card card;

    static APDUSender getSender(ShellPanel shellPanel) {
        APDUSender sender = senders.get(shellPanel);
        if (sender == null) {
            sender = new APDUSender(shellPanel);
            senders.put(shellPanel, sender);
        }
        return sender;
    }

    public static String getString(String key) {
        return NbBundle.getMessage(APDUSender.class, (String)key);
    }

    private APDUSender(ShellPanel shellPanel) {
        this.card = shellPanel.getCard();
    }

    public String setExtended(boolean yesNo) {
        this.extended = yesNo;
        return yesNo ? APDUSender.getString("EXTENDED_MODE_ON") : APDUSender.getString("EXTENDED_MODE_OFF");
    }

    public String setContactless(boolean yesNo) {
        this.contactless = yesNo;
        return yesNo ? APDUSender.getString("CONTACTLESS_ON") : APDUSender.getString("CONTACTLESS_OFF");
    }

    public String powerup() throws IOException, CadTransportException {
        if (this.contactless) {
            return this.powerupContactless();
        }
        return this.powerupContacted();
    }

    public String powerdown() throws IOException, CadTransportException {
        if (this.contactless) {
            return this.powerdownContactless();
        }
        return this.powerdownContacted();
    }

    public String powerupContacted() throws IOException, CadTransportException {
        PortProvider prov = (PortProvider)this.card.getCapability(PortProvider.class);
        UrlCapability apdu = (UrlCapability)this.card.getCapability(UrlCapability.class);
        int contactedPort = prov.getPort(PortKind.CONTACTED);
        this.contactedSocket = new Socket(prov.getHost(), contactedPort);
        this.contactedSocket.setTcpNoDelay(true);
        switch (apdu.getContactedProtocol()) {
            case T0: {
                this.contactedInterface = new CadT0Client((InputStream)new BufferedInputStream(this.contactedSocket.getInputStream()), (OutputStream)new BufferedOutputStream(this.contactedSocket.getOutputStream()));
                break;
            }
            case T1: {
                this.contactedInterface = new CadT1Client((InputStream)new BufferedInputStream(this.contactedSocket.getInputStream()), (OutputStream)new BufferedOutputStream(this.contactedSocket.getOutputStream()));
                break;
            }
            default: {
                throw new IOException("No contacted protocol specified");
            }
        }
        this.contactedInterface.powerUp();
        return "";
    }

    public String powerdownContacted() throws IOException, CadTransportException {
        try {
            this.contactedInterface.powerDown();
            this.contactedSocket.close();
            this.contactedInterface = null;
            this.contactedSocket = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public String powerupContactless() throws IOException, CadTransportException {
        PortProvider prov = (PortProvider)this.card.getLookup().lookup(PortProvider.class);
        int contactlessport = prov.getPort(PortKind.CONTACTLESS);
        this.contactlessSocket = new Socket(prov.getHost(), contactlessport);
        this.contactlessSocket.setTcpNoDelay(true);
        this.contactlessInterface = new CadT1Client((InputStream)new BufferedInputStream(this.contactlessSocket.getInputStream()), (OutputStream)new BufferedOutputStream(this.contactlessSocket.getOutputStream()));
        this.contactlessInterface.powerUp();
        return "";
    }

    public String powerdownContactless() throws IOException, CadTransportException {
        try {
            this.contactlessInterface.powerDown();
            this.contactlessSocket.close();
            this.contactlessInterface = null;
            this.contactlessSocket = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public String send(String apduString) throws IOException, ShellException, CadTransportException {
        if (this.contactless) {
            return this.sendContactless(apduString);
        }
        return this.sendContacted(apduString);
    }

    public String sendContacted(String apduString) throws IOException, ShellException, CadTransportException {
        if (this.contactedInterface == null) {
            this.powerup();
        }
        try {
            Apdu apdu = new Apdu(APDUSender.toBytes(apduString));
            apdu.isExtended = this.extended;
            this.contactedInterface.exchangeApdu(apdu);
            String response = apdu.toString();
            return response;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            ShellException e = new ShellException(NbBundle.getMessage(APDUSender.class, (String)"MSG_INSUFFICIENT_BYTES", (Object)aioobe.getMessage()));
            e.initCause(aioobe);
            throw e;
        }
    }

    public String sendContactless(String apduString) throws IOException, ShellException, CadTransportException {
        if (this.contactlessInterface == null) {
            this.powerup();
        }
        Apdu apdu = new Apdu(APDUSender.toBytes(apduString));
        apdu.isExtended = this.extended;
        this.contactlessInterface.exchangeApdu(apdu);
        String response = apdu.toString();
        return response;
    }

    static byte[] toBytes(String str) throws ShellException {
        return new APDUParser(str).bytes();
    }
}

