/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.BreakpointPanel;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.NativeBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.ExceptionBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.modules.cnd.debugger.common2.values.ExceptionSpec;

class ExceptionBreakpointPanel
extends BreakpointPanel {
    private ExceptionBreakpoint fb;
    private ButtonGroup buttonGroup1;
    private JLabel exceptionLabel;
    private JComboBox exceptionCombo;

    @Override
    protected final void seed(NativeBreakpoint breakpoint) {
        this.seedCommonComponents(breakpoint);
        this.fb = (ExceptionBreakpoint)breakpoint;
        this.exceptionCombo.setSelectedItem(this.fb.getException().toString());
    }

    public ExceptionBreakpointPanel() {
        this(new ExceptionBreakpoint(2), false);
    }

    public ExceptionBreakpointPanel(NativeBreakpoint b) {
        this((ExceptionBreakpoint)b, true);
    }

    public ExceptionBreakpointPanel(ExceptionBreakpoint breakpoint, boolean customizing) {
        super(breakpoint, customizing);
        this.fb = breakpoint;
        this.initComponents();
        this.addCommonComponents(1);
        String[] comboValues = ExceptionSpec.getTags();
        this.exceptionCombo.setModel(new DefaultComboBoxModel<String>(comboValues));
        this.exceptionCombo.setEditable(true);
        Component c = this.exceptionCombo.getEditor().getEditorComponent();
        if (c instanceof JTextComponent) {
            Document d = ((JTextComponent)c).getDocument();
            d.addDocumentListener(this);
        }
        this.exceptionCombo.setSelectedIndex(0);
        this.seed(breakpoint);
        this.exceptionCombo.addItemListener(this);
    }

    @Override
    public void setDescriptionEnabled(boolean enabled) {
        this.exceptionCombo.setEnabled(false);
    }

    private void initComponents() {
        this.exceptionLabel = new JLabel();
        this.exceptionCombo = new JComboBox();
        this.panel_settings.setLayout(new GridBagLayout());
        this.exceptionLabel.setText(Catalog.get("Type"));
        this.exceptionLabel.setDisplayedMnemonic(Catalog.getMnemonic("MNEM_Type"));
        this.exceptionLabel.setLabelFor(this.exceptionCombo);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.ipadx = 5;
        gridBagConstraints1.anchor = 17;
        this.panel_settings.add((Component)this.exceptionLabel, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 3;
        gridBagConstraints1.fill = 0;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.weightx = 1.0;
        this.panel_settings.add((Component)this.exceptionCombo, gridBagConstraints1);
        this.exceptionCombo.getAccessibleContext().setAccessibleDescription(Catalog.get("ACSD_Type"));
    }

    @Override
    protected void assignProperties() {
        String xs = this.exceptionCombo.getSelectedItem().toString();
        ExceptionSpec x = ExceptionSpec.byTag(xs);
        this.fb.setException(x);
    }

    @Override
    protected boolean propertiesAreValid() {
        return !IpeUtils.isEmpty(this.exceptionCombo.getSelectedItem().toString());
    }
}

