/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types;

import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerAnnotation;
import org.netbeans.modules.cnd.debugger.common2.debugger.EditorBridge;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.NativeBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.LineBreakpointType;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.modules.cnd.debugger.common2.utils.props.IntegerProperty;
import org.netbeans.modules.cnd.debugger.common2.utils.props.StringProperty;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.text.Line;

public final class LineBreakpoint
extends NativeBreakpoint {
    private FileSystem fs = null;
    public IntegerProperty lineNumber = new IntegerProperty(this.pos, "lineNumber", null, false, -1);
    public StringProperty fileName = new StringProperty(this.pos, "fileName", null, false, null);

    public LineBreakpoint(int flags) {
        super(LineBreakpointType.getDefault(), flags);
    }

    private void setFileName(String fileName) {
        if (IpeUtils.sameString(this.fileName.toString(), fileName)) {
            return;
        }
        this.fileName.set(fileName);
    }

    public String getShortFileName() {
        if (this.fileName.get() == null) {
            return "";
        }
        return CndPathUtilities.getBaseName((String)this.fileName.get());
    }

    public String getFileName() {
        if (this.fileName.get() == null) {
            return "";
        }
        return this.fileName.get();
    }

    @Override
    public void removeAnnotations() {
        int annoLineNo = this.annoLineNo();
        if (annoLineNo != 0) {
            this.lineNumber.set(annoLineNo);
        }
        super.removeAnnotations();
    }

    private void setLineNumber(int newLineNumber) {
        if (this.annoLineNo() != 0) {
            this.removeAnnotations();
            this.lineNumber.set(newLineNumber);
            this.addAnnotation(this.fileName.get(), this.lineNumber.get(), 0L);
        } else {
            this.lineNumber.set(newLineNumber);
        }
    }

    public void setLineNumberInitial(int newLineNumber) {
        if (this.annoLineNo() != 0) {
            this.removeAnnotations();
            this.lineNumber.setFromObjectInitial(newLineNumber);
            this.addAnnotation(this.fileName.get(), this.lineNumber.get(), 0L);
        } else {
            this.lineNumber.setFromObjectInitial(newLineNumber);
        }
    }

    @Override
    protected Line getLine(String filename, int line) {
        if (line != 0 && this.fs != null) {
            return EditorBridge.getLine(filename, line, this.fs);
        }
        return super.getLine(filename, line);
    }

    @Override
    public NativeBreakpoint makeEditableCopy() {
        LineBreakpoint res = (LineBreakpoint)super.makeEditableCopy();
        res.fs = this.fs;
        return res;
    }

    @Override
    public void seedToplevelAnnotations() {
        super.seedToplevelAnnotations();
        if (NativeDebuggerManager.isPerTargetBpts()) {
            return;
        }
        this.addAnnotation(this.getFileName(), this.getLineNumber(), 0L);
    }

    public int getLineNumber() {
        int lineNo = this.annoLineNo();
        if (lineNo == 0) {
            lineNo = this.lineNumber.get();
        }
        return lineNo;
    }

    private int annoLineNo() {
        DebuggerAnnotation[] annotations = this.annotations();
        if (annotations.length > 0) {
            DebuggerAnnotation a = annotations[0];
            return a.getLineNo();
        }
        return 0;
    }

    public void setFileAndLine(String fileName, int lineNumber) {
        this.setFileName(fileName);
        this.setLineNumber(lineNumber);
    }

    public void setFileAndLine(String fileName, int lineNumber, FileSystem fs) {
        this.setFileName(fileName);
        this.setLineNumber(lineNumber);
        this.fs = fs;
    }

    public void setFilesystem(FileSystem fs) {
        this.fs = fs;
    }

    @Override
    protected final String getSummary() {
        return Catalog.format("CTL_Line_event_name", this.getFileName(), this.getLineNumber());
    }

    @Override
    protected String getDisplayNameHelp() {
        return CndPathUtilities.getBaseName((String)this.getFileName()) + ":" + this.getLineNumber();
    }

    @Override
    protected void processOriginalEventspec(String oeventspec) {
        assert (IpeUtils.isEmpty(oeventspec));
    }

    @Override
    public Breakpoint.GroupProperties getGroupProperties() {
        return new LineGroupProperties();
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    private class LineGroupProperties
    extends NativeBreakpoint.NativeGroupProperties {
        private final FileObject fo;

        private LineGroupProperties() {
            this.fo = EditorBridge.findFileObject(LineBreakpoint.this.getFileName(), LineBreakpoint.this.getDebugger());
        }

        @Override
        public FileObject[] getFiles() {
            if (this.fo != null) {
                return new FileObject[]{this.fo};
            }
            return null;
        }

        @Override
        public Project[] getProjects() {
            Project p = FileOwnerQuery.getOwner((FileObject)this.fo);
            if (p != null) {
                return new Project[]{p};
            }
            return null;
        }
    }
}

