/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.options;

import java.beans.PropertyChangeSupport;
import org.netbeans.modules.cnd.api.xml.XMLDecoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoder;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineType;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineTypeManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.EngineNodeProp;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.EngineProfileXMLCodec;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.ProfileSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObject;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;

public final class EngineProfile
extends ProfileSupport {
    public static final String PROFILE_ID = "nativedebugger";
    public static final String PROP_ENGINE = "engine";
    protected EngineType engineType = EngineTypeManager.getOverrideEngineType();

    protected EngineProfile(PropertyChangeSupport pcs) {
        super(pcs);
        if (this.engineType == null) {
            this.engineType = EngineTypeManager.getFallbackEnineType();
        }
    }

    public void initialize() {
    }

    @Override
    public String getId() {
        return PROFILE_ID;
    }

    public void setEngineType(EngineType newEngineType) {
        this.engineType = newEngineType;
        this.needSave = true;
    }

    public EngineType setEngineByID(String newEngineID) {
        EngineType oldEngine = this.engineType;
        this.engineType = EngineTypeManager.getEngineTypeByID(newEngineID);
        if (this.pcs != null) {
            this.pcs.firePropertyChange(PROP_ENGINE, oldEngine, this.engineType);
        }
        this.needSave = true;
        return this.engineType;
    }

    public EngineType getEngineType() {
        return this.engineType;
    }

    @Override
    public XMLDecoder getXMLDecoder() {
        return new EngineProfileXMLCodec(this);
    }

    @Override
    public XMLEncoder getXMLEncoder() {
        return new EngineProfileXMLCodec(this);
    }

    @Override
    public void assign(ConfigurationAuxObject profileAuxObject) {
        if (!(profileAuxObject instanceof EngineProfile)) {
            System.err.print("Profile - assign: Profile object type expected - got " + profileAuxObject);
            return;
        }
        EngineProfile that = (EngineProfile)profileAuxObject;
        this.setValidatable(that.isValidatable());
        this.setEngineType(that.getEngineType());
    }

    @Override
    public ConfigurationAuxObject clone(Configuration conf) {
        EngineProfile clone = new EngineProfile(null);
        clone.setValidatable(this.isValidatable());
        clone.setEngineType(this.getEngineType());
        return clone;
    }

    @Override
    public Sheet getSheet() {
        Sheet sheet = new Sheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("General");
        set.setDisplayName(Catalog.get("GeneralTxt"));
        set.setShortDescription(Catalog.get("GeneralHint"));
        set.put((Node.Property)new EngineNodeProp(this));
        sheet.put(set);
        return sheet;
    }
}

