/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.options;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.SignalTableModel;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.Signals;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.HelpCtx;

class SignalsPanel
extends JPanel
implements HelpCtx.Provider,
PropertyChangeListener {
    private JLabel sigTableLabel;
    private JScrollPane signalScrollPane;
    private JTable signalTable;
    private SignalTableModel sigmodel;
    private Signals signals;
    private PropertyEditorSupport propertyEditor;

    public SignalsPanel(PropertyEditorSupport propertyEditor, PropertyEnv env, Signals signals) {
        this.propertyEditor = propertyEditor;
        this.initComponents();
        env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        env.addPropertyChangeListener((PropertyChangeListener)this);
        assert (signals.isClone()) : "SignalsPanel.<init>() didn't get a clone";
        this.signals = signals;
        if (signals.count() == 0) {
            this.sigmodel.signalsUpdated(null);
        } else {
            this.sigmodel.signalsUpdated(signals);
        }
    }

    private Object getPropertyValue() throws IllegalStateException {
        return this.signals;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("state".equals(evt.getPropertyName()) && evt.getNewValue() == PropertyEnv.STATE_VALID) {
            this.propertyEditor.setValue(this.getPropertyValue());
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("DebuggerOptions");
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(12, 12, 12, 12);
        EmptyBorder margin = new EmptyBorder(insets);
        CompoundBorder border = new CompoundBorder(new EtchedBorder(), margin);
        this.setBorder(border);
        this.sigTableLabel = new JLabel();
        String labelText = Catalog.get("SignalsTable");
        this.sigTableLabel.setText(labelText);
        this.sigTableLabel.setDisplayedMnemonic(Catalog.getMnemonic("MNEM_SignalsTable"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        this.add((Component)this.sigTableLabel, gbc);
        this.signalScrollPane = new JScrollPane();
        this.sigmodel = new SignalTableModel();
        this.signalTable = new JTable(this.sigmodel);
        this.signalScrollPane.setViewportView(this.signalTable);
        this.signalTable.setAutoResizeMode(4);
        Catalog.setAccessibleName(this.signalTable, "ACSN_SignalsTable");
        Catalog.setAccessibleDescription(this.signalTable, "ACSD_SignalsTable");
        this.signalTable.setAutoCreateColumnsFromModel(false);
        this.signalTable.setDefaultRenderer(Object.class, new SignalCellRenderer());
        TableColumnModel columnModel = this.signalTable.getColumnModel();
        DefaultComboBoxModel<String> combomodel = new DefaultComboBoxModel<String>(new String[]{Catalog.get("Signal_Ignored"), Catalog.get("Signal_Caught"), Catalog.get("Signal_Default")});
        JComboBox<String> comboBox = new JComboBox<String>(combomodel);
        comboBox.setEditable(false);
        comboBox.getAccessibleContext().setAccessibleName(Catalog.get("ACSN_HandledCombo"));
        DefaultCellEditor tce = new DefaultCellEditor(comboBox);
        columnModel.getColumn(3).setCellEditor(tce);
        columnModel.getColumn(0).setPreferredWidth(15);
        columnModel.getColumn(1).setPreferredWidth(15);
        columnModel.getColumn(2).setPreferredWidth(45);
        columnModel.getColumn(3).setPreferredWidth(25);
        this.sigTableLabel.setLabelFor(this.signalTable);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.signalScrollPane, gbc);
    }

    private static class SignalCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            TableModel model = table.getModel();
            if (!(model instanceof SignalTableModel)) {
                return this;
            }
            SignalTableModel signalModel = (SignalTableModel)model;
            if (!signalModel.isDefaultValue(row)) {
                Font font = this.getFont();
                font = font.deriveFont(1);
                this.setFont(font);
            }
            return this;
        }
    }
}

