/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.source;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.modules.cnd.source.spi.CndPropertiesProvider;
import org.netbeans.modules.cnd.source.spi.RenameHandler;
import org.openide.actions.OpenAction;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;

public class SourceDataNode
extends DataNode {
    private static final Logger LOG = Logger.getLogger(SourceDataNode.class.getName());

    public SourceDataNode(DataObject obj, Lookup lookup, String icon) {
        super(obj, Children.LEAF, lookup);
        this.setIconBaseWithExtension(icon);
    }

    protected Sheet createSheet() {
        Sheet defaultSheet = super.createSheet();
        CndPropertiesProvider.getDefault().addExtraProperties(this, defaultSheet);
        return defaultSheet;
    }

    public Action getPreferredAction() {
        Action result = super.getPreferredAction();
        return result == null ? SystemAction.get(OpenAction.class) : result;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("Welcome_cpp_home");
    }

    public void setName(String name) {
        RenameHandler handler = SourceDataNode.getRenameHandler();
        if (handler == null) {
            super.setName(name);
        } else {
            try {
                handler.handleRename((Node)this, name);
            }
            catch (IllegalArgumentException ioe) {
                super.setName(name);
            }
        }
    }

    private static synchronized RenameHandler getRenameHandler() {
        Collection handlers = Lookup.getDefault().lookupAll(RenameHandler.class);
        if (handlers.isEmpty()) {
            return null;
        }
        if (handlers.size() > 1) {
            LOG.log(Level.WARNING, "Multiple instances of RenameHandler found in Lookup; only using first one: {0}", handlers);
        }
        return (RenameHandler)handlers.iterator().next();
    }
}

