/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.mixeddev.java;

import com.sun.source.util.TreePath;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.modules.cnd.mixeddev.java.AbstractResolveJavaContextTask;
import org.netbeans.modules.cnd.mixeddev.java.JavaContextSupport;
import org.netbeans.modules.cnd.mixeddev.java.model.JavaEntityInfo;
import org.netbeans.modules.cnd.mixeddev.java.model.JavaFieldInfo;
import org.netbeans.modules.cnd.mixeddev.java.model.JavaMethodInfo;
import org.netbeans.modules.cnd.mixeddev.java.model.JavaParameterInfo;

public class ResolveJavaEntityTask
extends AbstractResolveJavaContextTask<JavaEntityInfo> {
    public ResolveJavaEntityTask(int offset) {
        super(offset);
    }

    @Override
    protected void resolve(CompilationController controller, TreePath tp) {
        if (JavaContextSupport.isClassOrInterface(tp)) {
            this.result = JavaContextSupport.createClassInfo(controller, tp);
        } else if (JavaContextSupport.isMethod(tp)) {
            this.result = this.validateMethodInfo(JavaContextSupport.createMethodInfo(controller, tp));
        } else if (JavaContextSupport.isField(tp)) {
            this.result = this.validateFieldInfo(JavaContextSupport.createFieldInfo(controller, tp));
        }
    }

    private JavaMethodInfo validateMethodInfo(JavaMethodInfo mtdInfo) {
        for (JavaParameterInfo param : mtdInfo.getParameters()) {
            if (param != null && param.getName() != null) continue;
            return null;
        }
        return mtdInfo;
    }

    private JavaFieldInfo validateFieldInfo(JavaFieldInfo fieldInfo) {
        if (fieldInfo.getName() == null) {
            return null;
        }
        if (fieldInfo.getType() == null) {
            return null;
        }
        return fieldInfo;
    }
}

