/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.mixeddev.ui;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;

abstract class AbstactDynamicMenuAction
extends AbstractAction
implements ContextAwareAction {
    private final RequestProcessor requestProcessor;
    private final String menuName;

    public AbstactDynamicMenuAction(RequestProcessor requestProcessor, String menuName) {
        this.requestProcessor = requestProcessor;
        this.menuName = menuName;
    }

    @Override
    public boolean isEnabled() {
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        JMenu menu = new JMenu();
        menu.setText(this.menuName);
        int counter = 0;
        ArrayList<MenuItemWrapperAction> wrappers = new ArrayList<MenuItemWrapperAction>();
        Action[] actions = this.createActions(actionContext);
        for (Action action : actions) {
            menu.add(this.collect(wrappers, new MenuItemWrapperAction(counter++, action)));
        }
        for (MenuItemWrapperAction action : wrappers) {
            action.init(menu, this.requestProcessor);
        }
        return new MenuWrapperAction(menu);
    }

    protected abstract Action[] createActions(Lookup var1);

    private MenuItemWrapperAction collect(List<MenuItemWrapperAction> wrappers, MenuItemWrapperAction action) {
        wrappers.add(action);
        return action;
    }

    private static class MenuItemWrapperAction
    extends AbstractAction {
        private final int position;
        private final Action delegate;

        public MenuItemWrapperAction(int position, Action delegate) {
            super(String.valueOf(delegate.getValue("Name")));
            this.position = position;
            this.delegate = delegate;
        }

        public void init(JMenu menu, RequestProcessor requestProcessor) {
            if (this.position < menu.getItemCount()) {
                final JMenuItem item = menu.getItem(this.position);
                item.setEnabled(false);
                requestProcessor.post(new Runnable(){

                    @Override
                    public void run() {
                        item.setEnabled(MenuItemWrapperAction.this.delegate.isEnabled());
                    }
                });
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.delegate.actionPerformed(e);
        }
    }

    private static class MenuWrapperAction
    extends AbstractAction
    implements Presenter.Popup {
        private final JMenu menu;

        public MenuWrapperAction(JMenu menu) {
            this.menu = menu;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        public JMenuItem getPopupPresenter() {
            return this.menu;
        }
    }
}

