/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.selenium2.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.TestCreatorProvider;
import org.netbeans.modules.selenium2.api.Bundle;
import org.netbeans.modules.selenium2.spi.Selenium2SupportImpl;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public final class Selenium2Support {
    public static final String SELENIUM_FOLDER_NAME = "test";
    public static final String SELENIUM_LIBRARY_NAME = "Selenium2";
    public static final String DEFAULT_SERVER_PORT = "80";
    public static final String DEFAULT_SELENIUM_SERVER_PORT = "4444";
    public static final String SELENIUM_TESTCLASS_NAME_SUFFIX = "IT";
    private static Lookup.Result<Selenium2SupportImpl> implementations;
    private static List<Selenium2SupportImpl> cache;

    private Selenium2Support() {
    }

    public static final Selenium2SupportImpl findSelenium2Support(Project p) {
        if (p == null) {
            return null;
        }
        for (Selenium2SupportImpl s : Selenium2Support.getImplementations()) {
            if (!s.isSupportActive(p)) continue;
            return s;
        }
        return null;
    }

    public static DataObject loadTestTemplate(String templateID) {
        String path = templateID;
        try {
            FileObject fo = FileUtil.getConfigFile((String)path);
            if (fo == null) {
                Selenium2Support.noTemplateMessage(path);
                return null;
            }
            return DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException e) {
            Selenium2Support.noTemplateMessage(path);
            return null;
        }
    }

    public static boolean isSupportEnabled(FileObject[] activatedFOs) {
        Project p;
        Selenium2SupportImpl selenium2Support;
        if (activatedFOs == null || activatedFOs.length == 0) {
            return false;
        }
        if (activatedFOs[0] != null && activatedFOs[0].isValid() && (selenium2Support = Selenium2Support.findSelenium2Support(p = FileOwnerQuery.getOwner((FileObject)activatedFOs[0]))) != null) {
            return selenium2Support.isSupportEnabled(activatedFOs);
        }
        return false;
    }

    public static void runTests(FileObject[] activatedFOs, boolean isSelenium) {
        Project p;
        Selenium2SupportImpl selenium2Support;
        if (activatedFOs == null || activatedFOs.length == 0) {
            return;
        }
        if (activatedFOs[0] != null && activatedFOs[0].isValid() && (selenium2Support = Selenium2Support.findSelenium2Support(p = FileOwnerQuery.getOwner((FileObject)activatedFOs[0]))) != null) {
            selenium2Support.runTests(activatedFOs, isSelenium);
        }
    }

    public static ArrayList<FileObject> createTests(TestCreatorProvider.Context context) {
        Project p;
        Selenium2SupportImpl selenium2Support;
        FileObject[] activatedFOs = context.getActivatedFOs();
        ArrayList<FileObject> createdFiles = new ArrayList<FileObject>();
        if (activatedFOs[0] != null && activatedFOs.length != 0 && activatedFOs[0].isValid() && (selenium2Support = Selenium2Support.findSelenium2Support(p = FileOwnerQuery.getOwner((FileObject)activatedFOs[0]))) != null) {
            EditorCookie ed;
            FileObject dir = context.getTargetFolder();
            boolean singleClass = context.isSingleClass();
            if (singleClass) {
                FileObject seleniumTestFile = Selenium2Support.createSeleniumTestFile(selenium2Support, dir, context.getTestClassName());
                if (seleniumTestFile != null) {
                    createdFiles.add(seleniumTestFile);
                }
            } else {
                ArrayList<FileObject> activatedFOs2 = new ArrayList<FileObject>();
                for (FileObject fo : activatedFOs) {
                    if (fo.isData()) {
                        if (activatedFOs2.contains(fo)) continue;
                        activatedFOs2.add(fo);
                        continue;
                    }
                    if (!fo.isFolder()) continue;
                    Enumeration children = fo.getChildren(true);
                    while (children.hasMoreElements()) {
                        FileObject child = (FileObject)children.nextElement();
                        if (!child.isData() || activatedFOs2.contains(child)) continue;
                        activatedFOs2.add(child);
                    }
                }
                for (FileObject fo : activatedFOs2) {
                    FileObject seleniumTestFile = Selenium2Support.createSeleniumTestFile(selenium2Support, dir, selenium2Support.getSourceAndTestClassNames(fo, false, true)[1]);
                    if (seleniumTestFile == null) continue;
                    createdFiles.add(seleniumTestFile);
                }
            }
            if (createdFiles.size() == 1 && (ed = (EditorCookie)createdFiles.get(0).getLookup().lookup(EditorCookie.class)) != null) {
                ed.open();
            }
        }
        return createdFiles;
    }

    private static FileObject createSeleniumTestFile(Selenium2SupportImpl selenium2Support, FileObject targetFolder, String targetName) {
        try {
            String clazz;
            FileObject dir = targetFolder;
            String name = targetName.replace('.', '/');
            int index = name.lastIndexOf(47);
            String pkg = index > -1 ? name.substring(0, index) : "";
            String string = clazz = index > -1 ? name.substring(index + 1) : name;
            if (pkg.length() > 0) {
                try {
                    dir = FileUtil.createFolder((FileObject)targetFolder, (String)pkg);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            DataFolder df = DataFolder.findFolder((FileObject)dir);
            DataObject dTemplate = Selenium2Support.loadTestTemplate(selenium2Support.getTemplateID());
            String serverPort = null;
            if (serverPort == null) {
                serverPort = DEFAULT_SERVER_PORT;
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("server_port", serverPort);
            params.put("selenium_server_port", DEFAULT_SELENIUM_SERVER_PORT);
            DataObject dobj = dTemplate.createFromTemplate(df, clazz, params);
            return dobj.getPrimaryFile();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private static void noTemplateMessage(String temp) {
        String msg = Bundle.MSG_template_not_found(temp);
        NotifyDescriptor.Message descr = new NotifyDescriptor.Message((Object)msg, 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)descr);
    }

    private static synchronized List<Selenium2SupportImpl> getImplementations() {
        if (implementations == null) {
            implementations = Lookup.getDefault().lookupResult(Selenium2SupportImpl.class);
            implementations.addLookupListener(new LookupListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void resultChanged(LookupEvent ev) {
                    Class<Selenium2Support> clazz = Selenium2Support.class;
                    synchronized (Selenium2Support.class) {
                        cache = null;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            });
        }
        if (cache == null) {
            cache = new ArrayList<Selenium2SupportImpl>(implementations.allInstances());
        }
        return Collections.unmodifiableList(cache);
    }
}

