/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.swing.ProfilerColumnModel;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;

public class ProfilerTableContainer
extends JPanel {
    private static final String PROP_COLUMN = "column";
    private ProfilerTable table;
    private JScrollPane tableScroll;
    private JPanel scrollersPanel;

    public ProfilerTableContainer(final ProfilerTable table, boolean decorated, ColumnChangeAdapter adapter) {
        super(new BorderLayout());
        this.setOpaque(false);
        this.table = table;
        this.tableScroll = new JScrollPane(table){

            @Override
            protected JViewport createViewport() {
                if (this.getViewport() == null) {
                    return ProfilerTableContainer.this.customViewport(table);
                }
                return super.createViewport();
            }
        };
        this.tableScroll.setVerticalScrollBarPolicy(22);
        this.tableScroll.setHorizontalScrollBarPolicy(31);
        this.configureVerticalScrollBar(this.tableScroll.getVerticalScrollBar());
        if (!decorated) {
            this.tableScroll.setBorder(BorderFactory.createEmptyBorder());
            this.tableScroll.setViewportBorder(BorderFactory.createEmptyBorder());
        }
        this.add((Component)this.tableScroll, "Center");
        final ProfilerColumnModel cModel = table._getColumnModel();
        final Set<Integer> scrollableColumns = table.getScrollableColumns();
        if (scrollableColumns != null && !scrollableColumns.isEmpty()) {
            this.scrollersPanel = new JPanel(null){

                @Override
                public void doLayout() {
                    int height = this.getHeight();
                    if (height > 0) {
                        for (Component component : this.getComponents()) {
                            JScrollBar scroller = (JScrollBar)component;
                            int column = table.convertColumnIndexToView(ProfilerTableContainer.this.getColumn(scroller));
                            Rectangle rect = table.getTableHeader().getHeaderRect(column);
                            scroller.setBounds(rect.x, 0, rect.width, height);
                            scroller.doLayout();
                        }
                    }
                }

                @Override
                public Dimension getPreferredSize() {
                    Dimension d = super.getPreferredSize();
                    d.height = 0;
                    for (Component component : this.getComponents()) {
                        JScrollBar scroller = (JScrollBar)component;
                        if (!cModel.isColumnVisible(ProfilerTableContainer.this.getColumn(scroller))) continue;
                        d.height = Math.max(d.height, scroller.getPreferredSize().height);
                    }
                    return d;
                }
            };
            this.scrollersPanel.setOpaque(true);
            this.scrollersPanel.setBackground(UIUtils.getProfilerResultsBackground());
            for (final Integer column : scrollableColumns) {
                final JScrollBar scroller = new JScrollBar(0){
                    private boolean adjusting;
                    {
                        super(x0);
                        this.adjusting = false;
                        this.putClientProperty(ProfilerTableContainer.PROP_COLUMN, column);
                    }

                    @Override
                    public void setValue(int value) {
                        value = this.checkedValue(value);
                        super.setValue(value);
                        this.updateColumnOffset(value);
                    }

                    @Override
                    public void setValues(int value, int extent, int min, int max) {
                        if (this.adjusting) {
                            return;
                        }
                        value = this.checkedValue(value);
                        this.setEnabled(extent < max);
                        if (this.trackEnd()) {
                            value = max - extent;
                        }
                        super.setValues(value, extent, min, max);
                        this.updateColumnOffset(value);
                    }

                    @Override
                    public void setValueIsAdjusting(boolean b) {
                        this.adjusting = b;
                        super.setValueIsAdjusting(b);
                        if (!this.adjusting) {
                            ProfilerTableContainer.this.updateHorizontalScrollBars(table, column, false);
                        }
                    }

                    @Override
                    public int getUnitIncrement() {
                        return 20;
                    }

                    @Override
                    public int getUnitIncrement(int direction) {
                        return this.getUnitIncrement();
                    }

                    @Override
                    public int getBlockIncrement() {
                        return (int)((float)this.getVisibleAmount() * 0.9f);
                    }

                    @Override
                    public int getBlockIncrement(int direction) {
                        return this.getBlockIncrement();
                    }

                    private void updateColumnOffset(int value) {
                        table.setColumnOffset(column, value);
                    }

                    private boolean trackEnd() {
                        if (!this.isEnabled()) {
                            return false;
                        }
                        int visible = this.getVisibleAmount();
                        if (visible > 0) {
                            return this.getValue() + visible >= this.getMaximum();
                        }
                        return !table.isLeadingAlign(column);
                    }

                    private int checkedValue(int value) {
                        value = Math.max(0, value);
                        value = Math.min(this.getMaximum() - this.getVisibleAmount(), value);
                        return value;
                    }
                };
                scroller.addMouseWheelListener(new MouseWheelListener(){

                    @Override
                    public void mouseWheelMoved(MouseWheelEvent e) {
                        ProfilerTableContainer.scroll(scroller, e);
                    }
                });
                this.scrollersPanel.add(scroller);
            }
            MouseWheelListener[] listeners = this.tableScroll.getMouseWheelListeners();
            if (listeners != null && listeners.length == 1) {
                final MouseWheelListener listener = listeners[0];
                this.tableScroll.removeMouseWheelListener(listener);
                this.tableScroll.addMouseWheelListener(new MouseWheelListener(){

                    @Override
                    public void mouseWheelMoved(MouseWheelEvent e) {
                        if (ProfilerTableContainer.onlyShift(e)) {
                            int _c;
                            int c = table.columnAtPoint(e.getPoint());
                            int n = _c = c == -1 ? -1 : table.convertColumnIndexToModel(c);
                            if (_c != -1 && table.isScrollableColumn(_c)) {
                                JScrollBar scroller = ProfilerTableContainer.this.getScroller(_c);
                                if (scroller != null) {
                                    ProfilerTableContainer.scroll(scroller, e);
                                }
                                return;
                            }
                        }
                        listener.mouseWheelMoved(e);
                    }
                });
            }
            cModel.addColumnChangeListener(new ColumnChangeAdapter(){

                @Override
                public void columnWidthChanged(int column, int oldWidth, int newWidth) {
                    if (table.isScrollableColumn(column)) {
                        ProfilerTableContainer.this.updateHorizontalScrollBars(table, column, true);
                    }
                }

                @Override
                public void columnPreferredWidthChanged(int column, int oldWidth, int newWidth) {
                    if (table.isScrollableColumn(column)) {
                        ProfilerTableContainer.this.updateHorizontalScrollBars(table, column, false);
                    }
                }
            });
            cModel.addColumnModelListener(new TableColumnModelListener(){

                @Override
                public void columnAdded(TableColumnModelEvent e) {
                }

                @Override
                public void columnRemoved(TableColumnModelEvent e) {
                }

                @Override
                public void columnMoved(TableColumnModelEvent e) {
                    this.moved(e);
                }

                @Override
                public void columnMarginChanged(ChangeEvent e) {
                    this.margin(e);
                }

                @Override
                public void columnSelectionChanged(ListSelectionEvent e) {
                }

                private void moved(TableColumnModelEvent e) {
                    if (e.getFromIndex() != e.getToIndex()) {
                        ProfilerTableContainer.this.updateHorizontalScrollBars(table, -1, true);
                    }
                }

                private void margin(ChangeEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            for (Integer column : scrollableColumns) {
                                int _column = table.convertColumnIndexToView(column);
                                Rectangle rect = table.getTableHeader().getHeaderRect(_column);
                                Rectangle scroll = ProfilerTableContainer.this.getScroller(column).getBounds();
                                if (rect.x == scroll.x && rect.width == scroll.width) continue;
                                ProfilerTableContainer.this.updateHorizontalScrollBars(table, -1, true);
                                break;
                            }
                        }
                    });
                }
            });
            this.add((Component)this.scrollersPanel, "South");
        }
        if (adapter != null) {
            cModel.addColumnChangeListener(adapter);
        }
    }

    private static void scroll(JScrollBar scroller, MouseWheelEvent event) {
        if (event.getScrollType() == 0) {
            int newValue;
            int direction = event.getUnitsToScroll() < 0 ? -1 : 1;
            int increment = scroller.getUnitIncrement(direction);
            int amount = event.getScrollAmount();
            int oldValue = scroller.getValue();
            if (oldValue != (newValue = oldValue + increment * amount * direction)) {
                scroller.setValue(newValue);
            }
            event.consume();
        }
    }

    private static boolean onlyShift(MouseEvent e) {
        return e.isShiftDown() && !e.isAltDown() && !e.isAltGraphDown() && !e.isControlDown() && !e.isMetaDown();
    }

    public boolean tableNeedsScrolling() {
        return this.tableScroll.getVerticalScrollBar().isEnabled();
    }

    public BufferedImage createTableScreenshot(boolean onlyVisibleArea) {
        return onlyVisibleArea ? UIUtils.createScreenshot(this.tableScroll) : UIUtils.createScreenshot(this.table);
    }

    private int getColumn(JScrollBar scroller) {
        return (Integer)scroller.getClientProperty(PROP_COLUMN);
    }

    private JScrollBar getScroller(int column) {
        for (Component component : this.scrollersPanel.getComponents()) {
            JScrollBar scroller = (JScrollBar)component;
            if (this.getColumn(scroller) != column) continue;
            return scroller;
        }
        return null;
    }

    private JViewport customViewport(final JTable table) {
        return new JViewport(){
            private boolean listening;
            {
                this.setBackground(table.getBackground());
                table.addPropertyChangeListener("enabled", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        this.setBackground(table.getBackground());
                    }
                });
            }

            @Override
            public void paint(Graphics g) {
                block7: {
                    int viewHeight;
                    int height;
                    super.paint(g);
                    Component view = this.getView();
                    if (view != table) break block7;
                    if (!this.listening) {
                        this.hookColumns();
                    }
                    if ((height = this.getHeight()) > (viewHeight = view.getHeight())) {
                        g.setColor(table.getGridColor());
                        JTableHeader header = table.getTableHeader();
                        if (header != null) {
                            for (int i = 0; i < table.getColumnCount(); ++i) {
                                Rectangle rect = header.getHeaderRect(i);
                                if (rect.width <= 0) continue;
                                g.drawLine(rect.x + rect.width - 1, viewHeight, rect.x + rect.width - 1, height - 1);
                            }
                        } else if (table.getRowCount() > 0) {
                            for (int i = 0; i < table.getColumnCount(); ++i) {
                                Rectangle rect = table.getCellRect(0, i, true);
                                if (rect.width <= 0) continue;
                                g.drawLine(rect.x + rect.width - 1, viewHeight, rect.x + rect.width - 1, height - 1);
                            }
                        }
                    }
                }
            }

            private void hookColumns() {
                table.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

                    @Override
                    public void columnAdded(TableColumnModelEvent e) {
                        this.repaint();
                    }

                    @Override
                    public void columnRemoved(TableColumnModelEvent e) {
                        this.repaint();
                    }

                    @Override
                    public void columnMoved(TableColumnModelEvent e) {
                        this.repaint();
                    }

                    @Override
                    public void columnMarginChanged(ChangeEvent e) {
                        this.repaint();
                    }

                    @Override
                    public void columnSelectionChanged(ListSelectionEvent e) {
                        this.repaint();
                    }
                });
                this.listening = true;
            }
        };
    }

    private void configureVerticalScrollBar(final JScrollBar scrollBar) {
        scrollBar.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                scrollBar.setEnabled(ProfilerTableContainer.this.isEnabled() && scrollBar.getVisibleAmount() < scrollBar.getMaximum());
            }
        });
    }

    private void updateHorizontalScrollBars(ProfilerTable table, int column, boolean layout) {
        if (column != -1) {
            JScrollBar scroll = this.getScroller(column);
            int offset = table.getColumnOffset(column);
            int columnPref = table.getColumnPreferredWidth(column);
            int _column = table.convertColumnIndexToView(column);
            int columnAct = table.getTableHeader().getHeaderRect((int)_column).width;
            if (columnPref > columnAct) {
                int value = Math.min(offset, columnPref - columnAct);
                scroll.setValues(value, columnAct, 0, columnPref);
            } else {
                scroll.setValues(0, 0, 0, 0);
            }
        }
        if (layout) {
            this.doLayout();
            this.scrollersPanel.doLayout();
            this.repaint();
        }
    }

    public static class ColumnChangeAdapter
    implements ProfilerColumnModel.Listener {
        @Override
        public void columnOffsetChanged(int column, int oldOffset, int newOffset) {
        }

        @Override
        public void columnWidthChanged(int column, int oldWidth, int newWidth) {
        }

        @Override
        public void columnPreferredWidthChanged(int column, int oldWidth, int newWidth) {
        }
    }
}

