/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.spellchecker.bindings;

import java.util.regex.Pattern;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.modules.spellchecker.spi.language.TokenList;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class CndTokenList
implements TokenList {
    private Document doc;
    private boolean hidden = false;
    private String category;
    private Kind aKind = Kind.Comment;
    private int currentBlockStart;
    private int nextBlockStart;
    private String currentBlockText;
    private int currentOffsetInComment;
    private int currentWordOffset;
    private CharSequence currentWord;
    private int startOffset;
    private static final Pattern commentPattern = Pattern.compile("/\\*\\*([^*]*(\\*[^/][^*]*)*)\\*/", 40);
    private static final Pattern wordPattern = Pattern.compile("[A-Za-z]+");

    public CndTokenList(Document doc) {
        this.doc = doc;
    }

    public void setStartOffset(int offset) {
        this.currentBlockText = null;
        this.currentOffsetInComment = -1;
        this.startOffset = offset;
        this.nextBlockStart = offset;
        FileObject fileObject = FileUtil.getConfigFile((String)"Spellcheckers/CndComments");
        Boolean b = (Boolean)fileObject.getAttribute("Hidden");
        this.hidden = Boolean.TRUE.equals(b);
    }

    public int getCurrentWordStartOffset() {
        return this.currentWordOffset;
    }

    public CharSequence getCurrentWordText() {
        return this.currentWord;
    }

    public boolean nextWord() {
        if (this.hidden) {
            return false;
        }
        boolean hasNext = this.nextWordImpl();
        while (hasNext && this.currentWordOffset + this.currentWord.length() < this.startOffset) {
            hasNext = this.nextWordImpl();
        }
        return hasNext;
    }

    private int[] findNextComment() throws BadLocationException {
        final int[] out = new int[]{-1, -1};
        Runnable r = new Runnable(){

            @Override
            public void run() {
                TokenSequence ts = CndLexerUtilities.getCppTokenSequence((Document)CndTokenList.this.doc, (int)CndTokenList.this.nextBlockStart, (boolean)false, (boolean)false);
                if (ts == null) {
                    ts = CndLexerUtilities.getFortranTokenSequence((Document)CndTokenList.this.doc, (int)CndTokenList.this.nextBlockStart);
                }
                if (ts != null) {
                    int diff = ts.move(CndTokenList.this.nextBlockStart);
                    while (ts.moveNext()) {
                        CndTokenList.this.category = ts.token().id().primaryCategory();
                        if (CndTokenList.this.category == null || !"comment".equals(CndTokenList.this.category) && !"comment".equals(CndTokenList.this.category) && !"string".equals(CndTokenList.this.category) && !"string".equals(CndTokenList.this.category)) continue;
                        out[0] = ts.offset();
                        out[1] = ts.offset() + ts.token().length();
                        break;
                    }
                }
            }
        };
        this.doc.render(r);
        return out;
    }

    private void handleDoxygenTag(CharSequence tag) {
        if ("@see".contentEquals(tag) || "@throws".contentEquals(tag)) {
            Pair<CharSequence, Integer> data = this.wordBroker(this.currentBlockText, this.currentOffsetInComment, true, Kind.Doc);
            if (data != null) {
                this.currentOffsetInComment = (Integer)((Pair)data).b + ((CharSequence)((Pair)data).a).length();
            }
            return;
        }
        if ("@param".contentEquals(tag)) {
            Pair<CharSequence, Integer> data = this.wordBroker(this.currentBlockText, this.currentOffsetInComment, false, Kind.Doc);
            if (data != null) {
                this.currentOffsetInComment = (Integer)((Pair)data).b + ((CharSequence)((Pair)data).a).length();
            }
            return;
        }
        if ("@author".contentEquals(tag)) {
            Pair<CharSequence, Integer> data = this.wordBroker(this.currentBlockText, this.currentOffsetInComment, false, Kind.Doc);
            while (data != null) {
                this.currentOffsetInComment = (Integer)((Pair)data).b + ((CharSequence)((Pair)data).a).length();
                if ('\n' == ((CharSequence)((Pair)data).a).charAt(0)) {
                    return;
                }
                data = this.wordBroker(this.currentBlockText, this.currentOffsetInComment, false, Kind.Doc);
            }
            return;
        }
    }

    private boolean nextWordImpl() {
        try {
            while (true) {
                if (this.currentBlockText == null) {
                    int[] span = this.findNextComment();
                    if (span[0] == -1) {
                        return false;
                    }
                    this.aKind = "string".equals(this.category) ? Kind.String : Kind.Comment;
                    this.currentBlockStart = span[0];
                    this.currentBlockText = this.doc.getText(span[0], span[1] - span[0]);
                    this.currentOffsetInComment = 0;
                    this.nextBlockStart = span[1];
                }
                String pairTag = null;
                Pair<CharSequence, Integer> data = this.wordBroker(this.currentBlockText, this.currentOffsetInComment, false, this.aKind);
                while (data != null) {
                    this.currentOffsetInComment = (Integer)((Pair)data).b + ((CharSequence)((Pair)data).a).length();
                    if (pairTag == null) {
                        if (Character.isLetter(((CharSequence)((Pair)data).a).charAt(0)) && !CndTokenList.isIdentifierLike((CharSequence)((Pair)data).a)) {
                            this.currentWordOffset = this.currentBlockStart + (Integer)((Pair)data).b;
                            this.currentWord = (CharSequence)((Pair)data).a;
                            return true;
                        }
                        switch (((CharSequence)((Pair)data).a).charAt(0)) {
                            case '@': {
                                this.handleDoxygenTag((CharSequence)((Pair)data).a);
                                break;
                            }
                            case '<': {
                                if (CndTokenList.startsWith((CharSequence)((Pair)data).a, "<a ")) {
                                    pairTag = "</a>";
                                }
                                if (CndTokenList.startsWith((CharSequence)((Pair)data).a, "<code>")) {
                                    pairTag = "</code>";
                                }
                                if (!CndTokenList.startsWith((CharSequence)((Pair)data).a, "<pre>")) break;
                                pairTag = "</pre>";
                                break;
                            }
                            case '{': {
                                pairTag = "}";
                            }
                        }
                    } else if (pairTag.contentEquals((CharSequence)((Pair)data).a)) {
                        pairTag = null;
                    }
                    data = this.wordBroker(this.currentBlockText, this.currentOffsetInComment, false, this.aKind);
                }
                this.currentBlockText = null;
            }
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    private static boolean startsWith(CharSequence where, String withWhat) {
        if (where.length() >= withWhat.length()) {
            return withWhat.contentEquals(where.subSequence(0, withWhat.length()));
        }
        return false;
    }

    static boolean isIdentifierLike(CharSequence s) {
        boolean hasCapitalsInside = false;
        for (int offset = 1; offset < s.length() && !hasCapitalsInside; hasCapitalsInside |= Character.isUpperCase(s.charAt(offset)), ++offset) {
        }
        return hasCapitalsInside;
    }

    private boolean isLetter(char c) {
        return Character.isLetter(c) || c == '\'';
    }

    private Pair<CharSequence, Integer> wordBroker(CharSequence start, int offset, boolean treatSpecialCharactersAsLetterInsideWords, Kind kind) {
        int state = 0;
        int offsetStart = offset;
        while (start.length() > offset) {
            char current = start.charAt(offset);
            switch (state) {
                case 0: {
                    if (this.isLetter(current)) {
                        if (Kind.String == kind && offset > 0 && start.charAt(offset - 1) == '\\') break;
                        state = 1;
                        offsetStart = offset;
                        break;
                    }
                    if (current == '@' || current == '#') {
                        state = 2;
                        offsetStart = offset;
                        break;
                    }
                    if (current == '<') {
                        state = 3;
                        offsetStart = offset;
                        break;
                    }
                    if (current == '\n' || current == '}') {
                        return new Pair<CharSequence, Integer>(start.subSequence(offset, offset + 1), offset);
                    }
                    if (current != '{') break;
                    state = 4;
                    offsetStart = offset;
                    break;
                }
                case 1: {
                    if (this.isLetter(current) || (current == '.' || current == '#') && treatSpecialCharactersAsLetterInsideWords) break;
                    return new Pair<CharSequence, Integer>(start.subSequence(offsetStart, offset), offsetStart);
                }
                case 2: {
                    if (this.isLetter(current)) break;
                    return new Pair<CharSequence, Integer>(start.subSequence(offsetStart, offset), offsetStart);
                }
                case 3: {
                    if (current != '>') break;
                    return new Pair<CharSequence, Integer>(start.subSequence(offsetStart, offset + 1), offsetStart);
                }
                case 4: {
                    if (current == '@') {
                        state = 2;
                        break;
                    }
                    --offset;
                    state = 0;
                }
            }
            ++offset;
        }
        if (offset > offsetStart) {
            return new Pair<CharSequence, Integer>(start.subSequence(offsetStart, offset), offsetStart);
        }
        return null;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private static enum Kind {
        String,
        Comment,
        Doc;

    }

    private static class Pair<A, B> {
        private final A a;
        private final B b;

        public Pair(A a, B b) {
            this.a = a;
            this.b = b;
        }
    }
}

