/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.modules.javacard.project.ui.NodeCheckObserver;
import org.openide.awt.HtmlRenderer;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.ListView;
import org.openide.explorer.view.NodeRenderer;
import org.openide.nodes.Node;

public class CheckboxListView
extends ListView {
    public static final String SELECTED = "selected";
    private final EventHandler ml = new EventHandler();
    private boolean checkboxesEnabled = true;
    private NodeCheckObserver observer;
    private boolean enabled = true;

    public CheckboxListView() {
        this.setPopupAllowed(false);
        this.setViewportBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, UIManager.getColor("text")));
    }

    public void addNotify() {
        super.addNotify();
        this.list.setSelectionMode(0);
        if (this.checkboxesEnabled) {
            this.enableCheckboxes();
        }
    }

    public void setCheckboxesEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setListEnabled(boolean enabled) {
        this.list.setEnabled(enabled);
    }

    public final void setNodeCheckObserver(NodeCheckObserver observer) {
        this.observer = observer;
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.checkboxesEnabled) {
            this.disableCheckboxes();
        }
    }

    public final synchronized void setCheckboxesVisible(boolean val) {
        if (val != this.checkboxesEnabled) {
            this.checkboxesEnabled = val;
            if (this.isDisplayable()) {
                if (val) {
                    this.enableCheckboxes();
                } else {
                    this.disableCheckboxes();
                }
            }
        }
    }

    private void enableCheckboxes() {
        this.list.addMouseListener(this.ml);
        this.list.addKeyListener(this.ml);
        this.list.setCellRenderer(new CheckboxCellRenderer());
        this.repaint();
    }

    private void disableCheckboxes() {
        this.list.removeMouseListener(this.ml);
        this.list.removeKeyListener(this.ml);
        this.list.setCellRenderer(new NodeRenderer());
        this.repaint();
    }

    public void setCheckedNodes(Iterable<Node> nodes) {
        this.clearCheckedNodes();
        for (Node n : nodes) {
            n.setValue(SELECTED, (Object)Boolean.TRUE);
        }
        this.repaint();
    }

    public void clearCheckedNodes() {
        for (Node n : this.allNodes()) {
            boolean val = Boolean.TRUE.equals(n.getValue(SELECTED));
            if (this.observer != null) {
                this.observer.onNodeUnchecked(n);
            }
            n.setValue(SELECTED, (Object)Boolean.FALSE);
        }
        this.repaint();
    }

    private void selectNode(int index) {
        Node[] n;
        if (!this.enabled) {
            return;
        }
        if (index < 0) {
            return;
        }
        ExplorerManager.Provider prov = (ExplorerManager.Provider)SwingUtilities.getAncestorOfClass(ExplorerManager.Provider.class, (Component)((Object)this));
        if (prov != null && index < (n = prov.getExplorerManager().getRootContext().getChildren().getNodes()).length) {
            Boolean val = (Boolean)n[index].getValue(SELECTED);
            boolean wasSet = val != null && val != false;
            n[index].setValue(SELECTED, (Object)(!wasSet ? 1 : 0));
            if (this.observer != null) {
                if (!wasSet) {
                    this.observer.onNodeChecked(n[index]);
                } else {
                    this.observer.onNodeUnchecked(n[index]);
                }
            }
            this.repaint();
        }
    }

    private Node[] allNodes() {
        ExplorerManager.Provider prov = (ExplorerManager.Provider)SwingUtilities.getAncestorOfClass(ExplorerManager.Provider.class, (Component)((Object)this));
        return prov == null ? new Node[]{} : prov.getExplorerManager().getRootContext().getChildren().getNodes();
    }

    private boolean isChecked(int index) {
        if (index < 0) {
            return false;
        }
        Node[] n = this.allNodes();
        return index > n.length - 1 ? false : Boolean.TRUE.equals(n[index].getValue(SELECTED));
    }

    private static class WrapperComponent
    extends JComponent {
        Component toPaint;
        private final JCheckBox box = new JCheckBox();

        WrapperComponent() {
            this.add(this.box);
            this.box.setBorder(BorderFactory.createEmptyBorder());
        }

        void setToPaint(Component toPaint) {
            if (this.toPaint != toPaint) {
                if (this.toPaint != null) {
                    this.remove(this.toPaint);
                }
                this.toPaint = toPaint;
                this.box.setBackground(toPaint.getBackground());
                this.add(toPaint);
            }
            this.doLayout();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension a = this.box.getPreferredSize();
            Dimension b = this.toPaint == null ? new Dimension(0, 0) : this.toPaint.getPreferredSize();
            return new Dimension(a.width + b.width, Math.max(a.height, b.height) + 1);
        }

        @Override
        public void doLayout() {
            Dimension a = this.box.getPreferredSize();
            Dimension size = this.getPreferredSize();
            Insets ins = this.getInsets();
            size.height -= ins.top + ins.bottom;
            int x = ins.left;
            int y = a.height == size.height ? ins.top : ins.top + (size.height / 2 - a.height / 2);
            this.box.setBounds(x, y, a.width, a.height);
            x += a.width;
            if (this.toPaint != null) {
                a = this.toPaint.getPreferredSize();
                y = a.height == size.height ? ins.top : ins.top + (size.height / 2 - a.height / 2);
                this.toPaint.setBounds(x, y, a.width, a.height);
            }
        }

        void setSelected(boolean val) {
            this.box.setSelected(val);
        }

        @Override
        public void repaint(int x, int y, int w, int h) {
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        }

        @Override
        public void invalidate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void repaint() {
        }

        @Override
        public void validate() {
        }
    }

    private final class CheckboxCellRenderer
    extends NodeRenderer {
        final WrapperComponent rr = new WrapperComponent();

        private CheckboxCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean sel, boolean cellHasFocus) {
            cellHasFocus = false;
            Component c = super.getListCellRendererComponent(list, value, index, sel, cellHasFocus);
            HtmlRenderer.Renderer r = (HtmlRenderer.Renderer)c;
            r.setIndent(20);
            this.rr.setSelected(CheckboxListView.this.isChecked(index));
            this.rr.setToPaint(c);
            this.rr.setEnabled(CheckboxListView.this.enabled);
            c.setEnabled(CheckboxListView.this.enabled);
            return this.rr;
        }
    }

    private class EventHandler
    extends KeyAdapter
    implements MouseListener {
        int pressIndex = -1;

        private EventHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                CheckboxListView.this.selectNode(this.findIndex(e));
                e.consume();
            }
        }

        private int findIndex(MouseEvent e) {
            JList jl = (JList)e.getSource();
            int result = jl.locationToIndex(e.getPoint());
            return result;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.pressIndex = this.findIndex(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int ix = this.findIndex(e);
            if (this.pressIndex == ix && e.getX() <= 24) {
                CheckboxListView.this.selectNode(ix);
                e.consume();
            }
            this.pressIndex = -1;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            JList jl = (JList)e.getSource();
            if (e.getKeyChar() == '\n' && e.getModifiers() == 0) {
                CheckboxListView.this.selectNode(jl.getSelectedIndex());
                e.consume();
            }
        }
    }
}

