/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.model.jclank.bridge.trace;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JMenuItem;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public abstract class JClankTraceProjectAbstractAction
extends NodeAction {
    protected static final boolean TEST_XREF = Boolean.getBoolean("test.xref.action");
    private static final RequestProcessor RP = new RequestProcessor("JClank Preprocessor", 1);
    private final JMenuItem presenter = new JMenuItem(this.getName());

    public JClankTraceProjectAbstractAction() {
        this.presenter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JClankTraceProjectAbstractAction.this.onActionPerformed();
            }
        });
    }

    public abstract String getName();

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public JMenuItem getMenuPresenter() {
        return this.getPresenter();
    }

    public JMenuItem getPopupPresenter() {
        return this.getPresenter();
    }

    private JMenuItem getPresenter() {
        this.presenter.setEnabled(true);
        this.presenter.setVisible(TEST_XREF);
        return this.presenter;
    }

    protected boolean enable(Node[] activatedNodes) {
        return true;
    }

    private void onActionPerformed() {
        this.performAction(this.getActivatedNodes());
    }

    public final void performAction(Node[] activatedNodes) {
        final Collection<NativeProject> projects = this.getNativeProjects(activatedNodes);
        if (!projects.isEmpty()) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    JClankTraceProjectAbstractAction.this.performActionImpl(projects);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performActionImpl(Collection<NativeProject> projects) {
        String taskName = this.getName();
        InputOutput io = IOProvider.getDefault().getIO(taskName, false);
        io.select();
        OutputWriter out = io.getOut();
        OutputWriter err = io.getErr();
        final AtomicBoolean cancelled = new AtomicBoolean(false);
        ProgressHandle handle = ProgressHandle.createHandle((String)taskName, (Cancellable)new Cancellable(){

            public boolean cancel() {
                cancelled.set(true);
                return true;
            }
        });
        handle.start();
        long time = System.currentTimeMillis();
        try {
            this.traceProjects(projects, out, err, handle, cancelled);
        }
        catch (Throwable e) {
            try {
                e.printStackTrace((PrintWriter)err);
            }
            catch (Throwable throwable) {
                handle.finish();
                if (this.printTiming()) {
                    out.printf("%s\n", new Object[]{cancelled.get() ? "Cancelled" : "Done"});
                    out.printf("%s took %d ms\n", new Object[]{taskName, System.currentTimeMillis() - time});
                }
                err.flush();
                out.flush();
                err.close();
                out.close();
                throw throwable;
            }
            handle.finish();
            if (this.printTiming()) {
                out.printf("%s\n", new Object[]{cancelled.get() ? "Cancelled" : "Done"});
                out.printf("%s took %d ms\n", new Object[]{taskName, System.currentTimeMillis() - time});
            }
            err.flush();
            out.flush();
            err.close();
            out.close();
        }
        handle.finish();
        if (this.printTiming()) {
            out.printf("%s\n", new Object[]{cancelled.get() ? "Cancelled" : "Done"});
            out.printf("%s took %d ms\n", new Object[]{taskName, System.currentTimeMillis() - time});
        }
        err.flush();
        out.flush();
        err.close();
        out.close();
    }

    protected boolean printTiming() {
        return true;
    }

    protected boolean asynchronous() {
        return false;
    }

    private Collection<NativeProject> getNativeProjects(Node[] nodes) {
        HashSet<NativeProject> projects = new HashSet<NativeProject>();
        for (Node node : nodes) {
            NativeProject np = (NativeProject)node.getLookup().lookup(NativeProject.class);
            if (np == null) {
                Object o;
                Project prj = (Project)node.getLookup().lookup(Project.class);
                if (prj == null && (o = node.getValue("Project")) instanceof Project) {
                    prj = (Project)o;
                }
                if (prj != null) {
                    np = (NativeProject)prj.getLookup().lookup(NativeProject.class);
                }
            }
            if (np == null) continue;
            projects.add(np);
        }
        return projects;
    }

    protected abstract void traceProjects(Collection<NativeProject> var1, OutputWriter var2, OutputWriter var3, ProgressHandle var4, AtomicBoolean var5);
}

