/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.log;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import org.netbeans.api.diff.DiffController;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.mercurial.remote.HgProgressSupport;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.ui.diff.DiffStreamSource;
import org.netbeans.modules.mercurial.remote.ui.log.DiffResultsView;
import org.netbeans.modules.mercurial.remote.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.remote.ui.log.RepositoryRevision;
import org.netbeans.modules.mercurial.remote.ui.log.SearchHistoryPanel;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

final class DiffResultsViewForLine
extends DiffResultsView {
    private final int lineNumber;

    public DiffResultsViewForLine(SearchHistoryPanel parent, List<RepositoryRevision> results, int lineNumber) {
        super(parent, results);
        this.lineNumber = Math.max(lineNumber - 1, 0);
        this.setButtonLabels();
    }

    @Override
    protected void showRevisionDiff(RepositoryRevision.Event rev, boolean showLastDifference) {
        if (rev.getFile() == null) {
            return;
        }
        this.showDiff(rev.getLogInfoHeader().getRepositoryRoot(), null, rev, showLastDifference);
    }

    @Override
    protected HgProgressSupport createShowDiffTask(RepositoryRevision.Event revision1, RepositoryRevision.Event revision2, boolean showLastDifference) {
        if (revision1 == null) {
            return new ShowDiffTask(revision2, revision2.getLogInfoHeader().getLog().getHgRevision(), showLastDifference);
        }
        return super.createShowDiffTask(revision1, revision2, showLastDifference);
    }

    @Override
    void onNextButton() {
        if (++this.currentIndex >= this.treeView.getRowCount()) {
            this.currentIndex = 0;
        }
        this.setDiffIndex(this.currentIndex, false);
    }

    @Override
    void onPrevButton() {
        if (--this.currentIndex < 0) {
            this.currentIndex = this.treeView.getRowCount() - 1;
        }
        this.setDiffIndex(this.currentIndex, true);
    }

    private void setButtonLabels() {
        this.parent.bNext.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DiffResultsViewForLine.class, (String)"ACSN_NextRevision"));
        this.parent.bNext.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DiffResultsViewForLine.class, (String)"ACSD_NextRevision"));
        this.parent.bNext.setToolTipText(NbBundle.getMessage(DiffResultsViewForLine.class, (String)"ACSD_NextRevision"));
        this.parent.bPrev.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DiffResultsViewForLine.class, (String)"ACSN_PrevRevision"));
        this.parent.bPrev.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DiffResultsViewForLine.class, (String)"ACSD_PrevRevision"));
        this.parent.bPrev.setToolTipText(NbBundle.getMessage(DiffResultsViewForLine.class, (String)"ACSD_PrevRevision"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getLastLineIndex(StreamSource ss) {
        StyledDocument styledDoc;
        block19: {
            Document doc;
            String mimeType = ss.getMIMEType();
            if (mimeType == null || !mimeType.startsWith("text/")) {
                Mercurial.LOG.log(Level.INFO, "Wrong mime type");
                return 0;
            }
            EditorKit kit = CloneableEditorSupport.getEditorKit((String)mimeType);
            if (kit == null) {
                Mercurial.LOG.log(Level.WARNING, "No editor kit available");
                return 0;
            }
            Document sdoc = this.getSourceDocument(ss);
            Document document = doc = sdoc != null ? sdoc : kit.createDefaultDocument();
            if (doc instanceof StyledDocument) {
                styledDoc = (StyledDocument)doc;
            } else {
                styledDoc = new DefaultStyledDocument(new StyleContext());
                kit = new StyledEditorKit();
            }
            if (sdoc == null) {
                Reader r = null;
                try {
                    r = ss.createReader();
                    if (r == null) break block19;
                    try {
                        kit.read(r, (Document)styledDoc, 0);
                    }
                    catch (BadLocationException e) {
                        throw new IOException("Can not locate the beginning of the document.");
                    }
                }
                catch (IOException ex) {
                    Mercurial.LOG.log(Level.INFO, null, ex);
                }
                finally {
                    try {
                        if (r != null) {
                            r.close();
                        }
                    }
                    catch (IOException ex) {
                        Mercurial.LOG.log(Level.INFO, null, ex);
                    }
                }
            }
        }
        return NbDocument.findLineNumber((StyledDocument)styledDoc, (int)styledDoc.getEndPosition().getOffset());
    }

    private Document getSourceDocument(StreamSource ss) {
        Document sdoc = null;
        FileObject fo = (FileObject)ss.getLookup().lookup(FileObject.class);
        if (fo != null) {
            try {
                EditorCookie ec;
                DataObject dao = DataObject.find((FileObject)fo);
                if (dao.getPrimaryFile() == fo && (ec = (EditorCookie)dao.getCookie(EditorCookie.class)) != null) {
                    sdoc = ec.openDocument();
                }
            }
            catch (Exception exception) {}
        } else {
            sdoc = (Document)ss.getLookup().lookup(Document.class);
        }
        return sdoc;
    }

    private void setLocation(int lineNumber, boolean showLineInLocal) {
        if (this.currentDiff == null) {
            return;
        }
        if (showLineInLocal) {
            this.currentDiff.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.LineNumber, lineNumber);
        } else {
            this.currentDiff.getJComponent().putClientProperty("diff.smartScrollDisabled", Boolean.TRUE);
            this.currentDiff.setLocation(DiffController.DiffPane.Base, DiffController.LocationType.LineNumber, lineNumber);
        }
    }

    private static class LocalFileDiffStreamSource
    extends StreamSource {
        private final FileObject fileObject;
        private final boolean isRight;
        private final VCSFileProxy file;
        private String mimeType;

        public LocalFileDiffStreamSource(VCSFileProxy file, boolean isRight) {
            this.file = file.normalizeFile();
            this.fileObject = this.file.toFileObject();
            this.isRight = isRight;
        }

        public boolean isEditable() {
            return this.isRight && this.fileObject != null && this.fileObject.canWrite();
        }

        public Lookup getLookup() {
            if (this.fileObject != null) {
                return Lookups.fixed((Object[])new Object[]{this.fileObject});
            }
            return Lookups.fixed((Object[])new Object[0]);
        }

        public String getName() {
            return this.file.getName();
        }

        public String getTitle() {
            return this.fileObject != null ? FileUtil.getFileDisplayName((FileObject)this.fileObject) : this.file.getPath();
        }

        public String getMIMEType() {
            this.mimeType = this.fileObject != null && this.fileObject.isValid() ? Mercurial.getInstance().getMimeType(this.file) : null;
            return this.mimeType;
        }

        public Reader createReader() throws IOException {
            if (this.mimeType == null || !this.mimeType.startsWith("text/")) {
                return null;
            }
            return Utils.createReader((FileObject)this.file.toFileObject());
        }

        public Writer createWriter(Difference[] conflicts) throws IOException {
            return null;
        }
    }

    private class ShowDiffTask
    extends HgProgressSupport {
        private final RepositoryRevision.Event header;
        private final HgLogMessage.HgRevision revision;

        public ShowDiffTask(RepositoryRevision.Event header, HgLogMessage.HgRevision revision, boolean showLastDifference) {
            this.header = header;
            this.revision = revision;
        }

        @Override
        public void perform() {
            DiffResultsViewForLine.this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_LoadingDiff"));
            final DiffStreamSource leftSource = new DiffStreamSource(this.header.getFile(), this.header.getFile(), this.revision, this.revision.getRevisionNumber());
            final LocalFileDiffStreamSource rightSource = new LocalFileDiffStreamSource(this.header.getFile(), true);
            leftSource.getMIMEType();
            if (this.isCanceled()) {
                DiffResultsViewForLine.this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_NoRevisions"));
                return;
            }
            rightSource.getMIMEType();
            if (this.isCanceled()) {
                DiffResultsViewForLine.this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_NoRevisions"));
                return;
            }
            if (DiffResultsViewForLine.this.currentTask != this) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (ShowDiffTask.this.isCanceled()) {
                            DiffResultsViewForLine.this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_NoRevisions"));
                            return;
                        }
                        DiffController view = DiffController.createEnhanced((StreamSource)leftSource, (StreamSource)rightSource);
                        int leftMaxLineNumber = DiffResultsViewForLine.this.getLastLineIndex(leftSource);
                        int rightMaxLineNumber = DiffResultsViewForLine.this.getLastLineIndex(rightSource);
                        if (DiffResultsViewForLine.this.currentTask == ShowDiffTask.this) {
                            DiffResultsViewForLine.this.currentDiff = view;
                            DiffResultsViewForLine.this.setBottomComponent(DiffResultsViewForLine.this.currentDiff.getJComponent());
                            if (leftMaxLineNumber != -1) {
                                DiffResultsViewForLine.this.setLocation(Math.min(leftMaxLineNumber, DiffResultsViewForLine.this.lineNumber), false);
                            }
                            if (rightMaxLineNumber != -1) {
                                DiffResultsViewForLine.this.setLocation(Math.min(rightMaxLineNumber, DiffResultsViewForLine.this.lineNumber), true);
                            }
                            DiffResultsViewForLine.this.parent.refreshComponents(false);
                        }
                    }
                    catch (IOException e) {
                        Mercurial.LOG.log(Level.INFO, null, e);
                    }
                }
            });
        }
    }
}

