/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.log;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.OutputLogger;
import org.netbeans.modules.mercurial.remote.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public abstract class SearchHistoryAction
extends ContextAction {
    static final int DIRECTORY_ENABLED_STATUS = -8;
    static final int FILE_ENABLED_STATUS = -8;

    protected SearchHistoryAction() {
    }

    protected SearchHistoryAction(String menuIcon) {
        super(menuIcon);
    }

    @Override
    protected boolean enable(Node[] nodes) {
        return HgUtils.isFromHgRepository(HgUtils.getCurrentContext(nodes));
    }

    protected static void outputSearchContextTab(VCSFileProxy repositoryRoot, String title) {
        OutputLogger logger = SearchHistoryAction.openLogger(repositoryRoot, title);
        logger.output(NbBundle.getMessage(SearchHistoryAction.class, (String)"MSG_LOG_ROOT_CONTEXT_SEP"));
        logger.output(repositoryRoot.getPath());
        SearchHistoryAction.closeLog(logger);
    }

    protected static void outputSearchContextTab(VCSFileProxy repositoryRoot, VCSFileProxy[] files, String title) {
        OutputLogger logger = SearchHistoryAction.openLogger(repositoryRoot, title);
        logger.output(NbBundle.getMessage(SearchHistoryAction.class, (String)"MSG_LOG_CONTEXT_SEP"));
        for (VCSFileProxy f : files) {
            logger.output(f.getPath());
        }
        SearchHistoryAction.closeLog(logger);
    }

    private static OutputLogger openLogger(VCSFileProxy repositoryRoot, String title) {
        OutputLogger logger = OutputLogger.getLogger(repositoryRoot);
        logger.outputInRed(NbBundle.getMessage(SearchHistoryAction.class, (String)title));
        logger.outputInRed(NbBundle.getMessage(SearchHistoryAction.class, (String)"MSG_Log_Title_Sep"));
        return logger;
    }

    private static void closeLog(OutputLogger logger) {
        logger.outputInRed("");
        logger.closeLog();
    }

    protected VCSFileProxy getRepositoryRoot(VCSContext context) {
        VCSFileProxy repositoryRoot = null;
        if (context != null) {
            VCSFileProxy[] roots = HgUtils.getActionRoots(context);
            if (roots != null && roots.length > 0) {
                repositoryRoot = Mercurial.getInstance().getRepositoryRoot(roots[0]);
            } else {
                VCSFileProxy repo = HgUtils.getRootFile(context);
                if (repo != null) {
                    Logger.getLogger(SearchHistoryAction.class.getName()).log(Level.INFO, "getActionRoots() returns empty, yet context contains {0} as root", repo);
                }
            }
        }
        return repositoryRoot;
    }

    protected VCSFileProxy[] getFiles(VCSContext context, VCSFileProxy repository) {
        VCSFileProxy[] files = null;
        if (repository != null) {
            files = HgUtils.filterForRepository(context, repository, false);
        }
        return files;
    }
}

