/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.merge;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import org.netbeans.modules.mercurial.remote.HgException;
import org.netbeans.modules.mercurial.remote.OutputLogger;
import org.netbeans.modules.mercurial.remote.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.remote.ui.repository.ChangesetPickerPanel;
import org.netbeans.modules.mercurial.remote.ui.update.UpdatePanel;
import org.netbeans.modules.mercurial.remote.util.HgCommand;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class MergeRevisionsPanel
extends ChangesetPickerPanel {
    public MergeRevisionsPanel(VCSFileProxy repo, VCSFileProxy[] roots) {
        super(repo, roots);
        this.initComponents();
        this.setInitMessageInfoFetcher(new HeadsInfoFetcher());
    }

    @Override
    protected String getRefreshLabel() {
        return NbBundle.getMessage(UpdatePanel.class, (String)"MSG_Refreshing_Update_Versions");
    }

    @Override
    protected boolean acceptSelection(HgLogMessage rev) {
        HgLogMessage.HgRevision parentRevision;
        boolean accepted;
        boolean bl = accepted = rev != null;
        if (accepted && (parentRevision = this.getParentRevision()) != null) {
            accepted = !rev.getCSetShortID().equals(parentRevision.getChangesetId());
        }
        return accepted;
    }

    @Override
    protected void loadRevisions() {
        super.loadRevisions();
    }

    private void initComponents() {
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(MergeRevisionsPanel.class, (String)"infoLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(MergeRevisionsPanel.class, (String)"infoLabel2.text"));
    }

    private static final class HeadsInfoFetcher
    extends ChangesetPickerPanel.MessageInfoFetcher {
        private HeadsInfoFetcher() {
        }

        @Override
        protected HgLogMessage[] getMessageInfo(VCSFileProxy repository, Set<VCSFileProxy> setRoots, int fetchRevisionLimit, OutputLogger logger) {
            HgLogMessage[] messages;
            try {
                messages = HgCommand.getHeadRevisionsInfo(repository, false, logger);
            }
            catch (HgException ex) {
                Logger.getLogger(MergeRevisionsPanel.class.getName()).log(Level.INFO, null, ex);
                messages = new HgLogMessage[]{};
            }
            return messages;
        }
    }
}

