/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.cli.commands;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.cli.SvnCommand;

public class VersionCommand
extends SvnCommand {
    private List<String> output = new ArrayList<String>();
    private boolean unsupportedVersion = false;
    private boolean supportedMetadataFormat = false;

    @Override
    protected int getCommand() {
        return 0;
    }

    @Override
    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("--version");
    }

    @Override
    protected void config(File configDir, String username, String password, SvnCommand.Arguments arguments) {
        arguments.addConfigDir(configDir);
    }

    @Override
    public void outputText(String lineString) {
        if (lineString == null || lineString.trim().equals("")) {
            return;
        }
        this.output.add(lineString);
        super.outputText(lineString);
    }

    public boolean checkForErrors() {
        Integer exitCode = this.getExitCode();
        if (exitCode == null || !exitCode.equals(0)) {
            return false;
        }
        boolean outputProduced = false;
        for (String string : this.output) {
            if ((string = string.trim()).length() == 0) continue;
            outputProduced = true;
            int pos = string.indexOf(" version ");
            if (pos > -1) {
                Subversion.LOG.log(Level.INFO, "Commandline client version: {0}", string.substring(pos + 9));
            }
            if (string.indexOf("version 0.") > -1 || string.indexOf("version 1.0") > -1 || string.indexOf("version 1.1") > -1 || string.indexOf("version 1.2") > -1 || string.indexOf("version 1.3") > -1 || string.indexOf("version 1.4") > -1) {
                this.unsupportedVersion = true;
                return false;
            }
            if (string.indexOf("version 1.5") <= -1 && string.indexOf("version 1.6") <= -1) continue;
            this.supportedMetadataFormat = true;
        }
        return outputProduced;
    }

    public boolean isUnsupportedVersion() {
        return this.unsupportedVersion;
    }

    public boolean isMetadataFormatSupported() {
        return this.supportedMetadataFormat;
    }

    public String getOutput() {
        StringBuffer sb = new StringBuffer();
        for (String string : this.output) {
            sb.append(string);
            sb.append('\n');
        }
        return sb.toString();
    }
}

