/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex;

import org.clang.basic.FileEntry;
import org.clang.basic.SourceRange;
import org.clang.lex.PreprocessedEntity;
import org.clang.lex.PreprocessingDirective;
import org.clang.lex.PreprocessingRecord;
import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;
import org.llvm.support.llvm;

public class InclusionDirective
extends PreprocessingDirective {
    private StringRef FileName = new StringRef();
    private boolean InQuotes;
    private byte Kind;
    private boolean ImportedModule;
    private FileEntry File;

    public InclusionDirective(PreprocessingRecord PPRec, InclusionKind Kind2, StringRef FileName, boolean InQuotes, boolean ImportedModule, FileEntry File, SourceRange Range) {
        super(PreprocessedEntity.EntityKind.InclusionDirectiveKind, Range);
        this.InQuotes = InQuotes;
        this.Kind = (byte)Kind2.getValue();
        this.ImportedModule = ImportedModule;
        this.File = File;
        char.ptr Memory = PPRec.Allocate(FileName.size() + 1, llvm.alignOf(Byte.TYPE));
        std.memcpy((char.ptr)Memory, (char.ptr)FileName.data(), (int)FileName.size());
        Memory.$set(FileName.size(), (byte)0);
        this.FileName.$assignMove(new StringRef(Memory, FileName.size()));
    }

    public InclusionKind getInclusionKind() {
        return InclusionKind.valueOf(this.Kind);
    }

    public StringRef getFileName() {
        return this.FileName;
    }

    public boolean wasInQuotes() {
        return this.InQuotes;
    }

    public boolean importedModule() {
        return this.ImportedModule;
    }

    public FileEntry getFile() {
        return this.File;
    }

    public static boolean classof(PreprocessedEntity PE) {
        return PE.getEntityKind() == PreprocessedEntity.EntityKind.InclusionDirectiveKind;
    }

    @Override
    public String toString() {
        return "FileName=" + this.FileName + ", InQuotes=" + this.InQuotes + ", Kind=" + this.Kind + ", ImportedModule=" + this.ImportedModule + ", File=" + this.File + super.toString();
    }

    public static final class InclusionKind
    extends Enum<InclusionKind>
    implements Native.ComparableLower {
        public static final /* enum */ InclusionKind Include = new InclusionKind(0);
        public static final /* enum */ InclusionKind Import = new InclusionKind(Include.getValue() + 1);
        public static final /* enum */ InclusionKind IncludeNext = new InclusionKind(Import.getValue() + 1);
        public static final /* enum */ InclusionKind IncludeMacros = new InclusionKind(IncludeNext.getValue() + 1);
        private final int value;
        private static final /* synthetic */ InclusionKind[] $VALUES;

        public static InclusionKind[] values() {
            return (InclusionKind[])$VALUES.clone();
        }

        public static InclusionKind valueOf(String name) {
            return Enum.valueOf(InclusionKind.class, name);
        }

        public static InclusionKind valueOf(int val) {
            InclusionKind out;
            InclusionKind inclusionKind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private InclusionKind(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((InclusionKind)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((InclusionKind)((Object)obj)).value);
        }

        static {
            $VALUES = new InclusionKind[]{Include, Import, IncludeNext, IncludeMacros};
        }

        private static final class Values {
            private static final InclusionKind[] VALUES;
            private static final InclusionKind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (InclusionKind kind : InclusionKind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new InclusionKind[min < 0 ? 1 - min : 0];
                VALUES = new InclusionKind[max >= 0 ? 1 + max : 0];
                for (InclusionKind kind : InclusionKind.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((InclusionKind)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((InclusionKind)kind).value] = kind;
                }
            }
        }
    }
}

