/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class URLRetriever {
    private static final WeakHashMap<String, String> PAGES_CACHE = new WeakHashMap();

    public static String getURLContentAndCache(URL url) {
        String path = url.getPath();
        String file_content = PAGES_CACHE.get(path);
        if (file_content == null) {
            try {
                ByteArrayOutputStream baos;
                try (InputStream is = url.openStream();){
                    byte[] buffer = new byte[8096];
                    baos = new ByteArrayOutputStream();
                    int count = 0;
                    do {
                        if ((count = is.read(buffer)) <= 0) continue;
                        baos.write(buffer, 0, count);
                    } while (count > 0);
                }
                file_content = baos.toString("UTF-8");
                baos.close();
            }
            catch (IOException e) {
                Logger.getAnonymousLogger().log(Level.WARNING, "Cannot read css help file.", e);
            }
            PAGES_CACHE.put(path, file_content);
        }
        return file_content;
    }
}

