/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.jdk.image;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.heapwalk.details.jdk.image.Bundle;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.windows.WindowManager;

class ImageExportAction
extends AbstractAction {
    private static final String DEFAULT_EXPORT_TYPE = "png";
    private static File exportDir;
    private JFileChooser fileChooser;
    private final Image image;

    ImageExportAction(Image image) {
        this.putValue("Name", Bundle.ImageDetailProvider_Action_Export());
        this.putValue("SmallIcon", Icons.getIcon((String)"GeneralIcons.Export"));
        this.putValue("ShortDescription", Bundle.ImageDetailProvider_Action_Export());
        this.putValue("iconBase", Icons.getResource((String)"GeneralIcons.Export"));
        this.image = image;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int result;
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setDialogType(1);
            this.fileChooser.setFileSelectionMode(2);
            this.fileChooser.setMultiSelectionEnabled(false);
            this.fileChooser.setDialogTitle(Bundle.ImageExportAction_Title());
            this.fileChooser.setApproveButtonText(Bundle.ImageExportAction_Ok());
            this.fileChooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(".png");
                }

                @Override
                public String getDescription() {
                    return Bundle.ImageExportAction_PNG();
                }
            });
        }
        if (exportDir != null) {
            this.fileChooser.setCurrentDirectory(exportDir);
        }
        if ((result = this.fileChooser.showSaveDialog((Component)WindowManager.getDefault().getRegistry().getActivated())) == 0) {
            exportDir = this.fileChooser.getCurrentDirectory();
            File target = this.fileChooser.getSelectedFile();
            if (target.exists() && !ProfilerDialogs.displayConfirmation((String)Bundle.ImageExportAction_OverwriteFileMsg(target.getName()), (String)Bundle.ImageExportAction_OverwriteFileCaption())) {
                return;
            }
            try {
                this.writeImage(this.fileChooser.getSelectedFile());
            }
            catch (IOException ex) {
                ProfilerDialogs.displayError((String)Bundle.ImageExportAction_Failed(ex.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeImage(File file) throws IOException {
        BufferedImage bi;
        String type;
        int idx = file.getName().lastIndexOf(46);
        if (idx == -1) {
            file = new File(file.getPath() + '.' + DEFAULT_EXPORT_TYPE);
            type = DEFAULT_EXPORT_TYPE;
        } else {
            type = file.getName().substring(idx + 1);
        }
        if (this.image instanceof BufferedImage) {
            bi = (BufferedImage)this.image;
        } else {
            bi = new BufferedImage(this.image.getWidth(null), this.image.getHeight(null), 2);
            bi.createGraphics().drawImage(this.image, 0, 0, null);
        }
        FileObject fo = FileUtil.createData((File)file);
        if (fo == null) {
            throw new IOException(Bundle.ImageExportAction_InvalidLoc());
        }
        OutputStream output = fo.getOutputStream();
        try {
            if (!ImageIO.write((RenderedImage)bi, type, output)) {
                throw new IOException(Bundle.ImageExportAction_WrongFormat(type));
            }
        }
        finally {
            output.close();
        }
    }
}

