/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.oql.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.NoCaret;
import org.netbeans.modules.profiler.oql.engine.api.OQLEngine;
import org.netbeans.modules.profiler.oql.engine.api.OQLException;
import org.netbeans.modules.profiler.oql.spi.OQLEditorImpl;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Lookup;

public class OQLEditor
extends JPanel {
    public static final String VALIDITY_PROPERTY = "document#valid";
    private volatile boolean lexervalid = false;
    private volatile boolean parserValid = false;
    private volatile boolean oldValidity = false;
    private JEditorPane queryEditor = null;
    private final OQLEngine engine;
    private final Color disabledBgColor = UIUtils.isGTKLookAndFeel() ? UIManager.getLookAndFeel().getDefaults().getColor("desktop") : UIManager.getColor("TextField.disabledBackground");
    private final transient Caret nullCaret = new NoCaret();
    private Color lastBgColor = null;
    private Caret lastCaret = null;

    public OQLEditor(OQLEngine engine) {
        this.engine = engine;
    }

    private void init() {
        final DocumentListener listener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                OQLEditor.this.validateScript();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                OQLEditor.this.validateScript();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                OQLEditor.this.validateScript();
            }
        };
        OQLEditorImpl impl = (OQLEditorImpl)Lookup.getDefault().lookup(OQLEditorImpl.class);
        if (impl != null) {
            this.queryEditor = impl.getEditorPane();
            this.queryEditor.getDocument().putProperty(OQLEngine.class, this.engine);
            this.queryEditor.getDocument().putProperty(OQLEditorImpl.ValidationCallback.class, new OQLEditorImpl.ValidationCallback(){

                public void callback(boolean lexingResult) {
                    OQLEditor.this.lexervalid = lexingResult;
                    OQLEditor.this.validateScript();
                }
            });
        } else {
            this.queryEditor = new JEditorPane(){

                @Override
                public void setText(String text) {
                    Document doc = this.getDocument();
                    if (doc != null) {
                        doc.removeDocumentListener(listener);
                    }
                    this.setDocument(this.getEditorKit().createDefaultDocument());
                    doc = this.getDocument();
                    if (doc != null) {
                        doc.addDocumentListener(listener);
                    }
                    super.setText(text);
                }
            };
            try {
                this.queryEditor.setContentType("text/x-oql");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            int fontsize = new JTextArea().getFont().getSize();
            this.queryEditor.setFont(new Font("Monospaced", 0, fontsize));
            this.lexervalid = true;
        }
        this.queryEditor.setOpaque(this.isOpaque());
        this.queryEditor.setBackground(this.getBackground());
        this.setLayout(new BorderLayout());
        this.add((Component)this.queryEditor, "Center");
    }

    public void setScript(String script) {
        this.editor().setText(script);
    }

    public String getScript() {
        return this.editor().getText();
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.queryEditor != null) {
            this.queryEditor.setBackground(bg);
        }
    }

    @Override
    public void setOpaque(boolean isOpaque) {
        super.setOpaque(isOpaque);
        if (this.queryEditor != null) {
            this.queryEditor.setOpaque(isOpaque);
        }
    }

    @Override
    public void requestFocus() {
        this.editor().requestFocus();
    }

    private final void validateScript() {
        if (this.lexervalid || !this.parserValid) {
            try {
                this.engine.parseQuery(this.getScript());
                this.parserValid = true;
            }
            catch (OQLException e) {
                StatusDisplayer.getDefault().setStatusText(e.getLocalizedMessage());
                this.parserValid = false;
            }
        }
        this.firePropertyChange(VALIDITY_PROPERTY, this.oldValidity, this.lexervalid && this.parserValid);
        this.oldValidity = this.lexervalid && this.parserValid;
    }

    public void setEditable(boolean b) {
        JEditorPane editor = this.editor();
        if (editor.isEditable() == b) {
            return;
        }
        editor.setEditable(b);
        if (b) {
            if (this.lastBgColor != null) {
                editor.setBackground(this.lastBgColor);
            }
            if (this.lastCaret != null) {
                editor.setCaret(this.lastCaret);
            }
        } else {
            this.lastBgColor = editor.getBackground();
            this.lastCaret = editor.getCaret();
            editor.setBackground(this.disabledBgColor);
            editor.setCaret(this.nullCaret);
        }
    }

    public boolean isEditable() {
        return this.editor().isEditable();
    }

    private JEditorPane editor() {
        if (this.queryEditor == null) {
            this.init();
        }
        return this.queryEditor;
    }
}

