/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.impl.spi;

import java.io.IOException;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.PersistentFactory;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.support.KeyFactory;

public final class LayerKey
implements Key {
    private final Key delegate;
    private final int unitId;

    private LayerKey(Key delegate, int unitIdInLayer) {
        this.delegate = delegate;
        this.unitId = unitIdInLayer;
    }

    @Override
    public PersistentFactory getPersistentFactory() {
        return this.delegate.getPersistentFactory();
    }

    @Override
    public CharSequence getUnit() {
        return this.delegate.getUnit();
    }

    @Override
    public int getUnitId() {
        return this.unitId;
    }

    @Override
    public Key.Behavior getBehavior() {
        return this.delegate.getBehavior();
    }

    @Override
    public boolean hasCache() {
        return this.delegate.hasCache();
    }

    @Override
    public int getDepth() {
        return this.delegate.getDepth();
    }

    @Override
    public CharSequence getAt(int level) {
        return this.delegate.getAt(level);
    }

    @Override
    public int getSecondaryDepth() {
        return this.delegate.getSecondaryDepth();
    }

    @Override
    public int getSecondaryAt(int level) {
        return this.delegate.getSecondaryAt(level);
    }

    public String toString() {
        return "LayerKey unitId=" + this.unitId + " delegate=" + this.delegate.getClass().getName();
    }

    public int hashCode() {
        int res = this.delegate.hashCode();
        assert (this.delegate.hashCode(0) + this.delegate.getUnitId() == res);
        return res - this.delegate.getUnitId() + this.unitId;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LayerKey)) {
            return false;
        }
        LayerKey other = (LayerKey)obj;
        if (other.delegate == this.delegate) {
            return true;
        }
        if (other.getUnitId() != this.unitId) {
            return false;
        }
        return this.delegate.equals(this.unitId, other.delegate, other.getUnitId());
    }

    public static LayerKey create(Key key, int unitIdInLayer) {
        return new LayerKey(key, unitIdInLayer);
    }

    public static void write(LayerKey key, RepositoryDataOutput output) throws IOException {
        output.writeInt(key.getUnitId());
        KeyFactory.getDefaultFactory().writeKey(key.delegate, output);
    }

    public static LayerKey read(RepositoryDataInput input) throws IOException {
        int unitIdInLayer = input.readInt();
        Key key = KeyFactory.getDefaultFactory().readKey(input);
        return new LayerKey(key, unitIdInLayer);
    }

    @Override
    public int hashCode(int unitID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(int thisUnitID, Key object, int objectUnitID) {
        throw new UnsupportedOperationException();
    }
}

