/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli;

import org.netbeans.modules.git.remote.cli.GitConflictDescriptor;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;

public final class GitStatus {
    private final VCSFileProxy file;
    private final String relativePath;
    private final boolean tracked;
    private GitConflictDescriptor conflictDescriptor;
    private Status statusHeadIndex;
    private Status statusIndexWC;
    private Status statusHeadWC;
    private boolean isFolder;
    private GitDiffEntry diffEntry;
    private final String workTreePath;
    private long indexEntryModificationDate;

    GitStatus(String workTreePath, VCSFileProxy file, String relativePath, boolean tracked) {
        this.workTreePath = workTreePath;
        this.file = file;
        this.relativePath = relativePath;
        this.tracked = tracked;
    }

    public VCSFileProxy getFile() {
        return this.file;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public Status getStatusHeadIndex() {
        return this.statusHeadIndex;
    }

    public Status getStatusIndexWC() {
        return this.statusIndexWC;
    }

    public Status getStatusHeadWC() {
        return this.statusHeadWC;
    }

    public boolean isTracked() {
        return this.tracked;
    }

    public boolean isConflict() {
        return this.conflictDescriptor != null;
    }

    public boolean isFolder() {
        return this.isFolder;
    }

    public boolean isCopied() {
        return this.diffEntry != null && this.diffEntry.getChangeType() == GitChangeType.COPY;
    }

    public boolean isRenamed() {
        return this.diffEntry != null && this.diffEntry.getChangeType() == GitChangeType.RENAME;
    }

    public VCSFileProxy getOldPath() {
        if (this.isRenamed() || this.isCopied()) {
            return VCSFileProxySupport.getResource((VCSFileProxy)this.file, (String)(this.workTreePath + "/" + this.diffEntry.getOldPath()));
        }
        return null;
    }

    public GitConflictDescriptor getConflictDescriptor() {
        return this.conflictDescriptor;
    }

    public long getIndexEntryModificationDate() {
        return this.indexEntryModificationDate;
    }

    void setDiffEntry(GitDiffEntry diffEntry) {
        this.diffEntry = diffEntry;
    }

    void setConflictDescriptor(GitConflictDescriptor conflictDescriptor) {
        this.conflictDescriptor = conflictDescriptor;
    }

    void setFolder(boolean isFolder) {
        this.isFolder = isFolder;
    }

    void setStatusHeadIndex(Status statusHeadIndex) {
        this.statusHeadIndex = statusHeadIndex;
    }

    void setStatusHeadWC(Status statusHeadWC) {
        this.statusHeadWC = statusHeadWC;
    }

    void setStatusIndexWC(Status statusIndexWC) {
        this.statusIndexWC = statusIndexWC;
    }

    void setIndexEntryModificationDate(long ts) {
        this.indexEntryModificationDate = ts;
    }

    public static enum GitChangeType {
        ADD,
        MODIFY,
        DELETE,
        RENAME,
        COPY;

    }

    public static class GitDiffEntry {
        private final GitChangeType type;
        private final String oldPath;

        public GitDiffEntry(GitChangeType type, String oldPath) {
            this.type = type;
            this.oldPath = oldPath;
        }

        public GitChangeType getChangeType() {
            return this.type;
        }

        public String getOldPath() {
            return this.oldPath;
        }
    }

    public static enum Status {
        STATUS_ADDED,
        STATUS_REMOVED,
        STATUS_NORMAL,
        STATUS_MODIFIED,
        STATUS_IGNORED;

    }
}

