/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.actions;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.git.remote.ui.actions.GitAction;
import org.netbeans.modules.git.remote.utils.GitUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public abstract class MultipleRepositoryAction
extends GitAction {
    private static final Logger LOG = Logger.getLogger(MultipleRepositoryAction.class.getName());

    protected MultipleRepositoryAction() {
        this(null);
    }

    protected MultipleRepositoryAction(String iconResource) {
        super(iconResource);
    }

    @Override
    protected final void performContextAction(final Node[] nodes) {
        Utils.postParallel((Runnable)new Runnable(){

            @Override
            public void run() {
                VCSContext context = MultipleRepositoryAction.this.getCurrentContext(nodes);
                MultipleRepositoryAction.this.performAction(context);
            }
        }, (int)0);
    }

    public final void performAction(VCSContext context) {
        Set<VCSFileProxy> repositories = GitUtils.getRepositoryRoots(context);
        if (repositories.isEmpty()) {
            LOG.log(Level.FINE, "No repository in the current context: {0}", context.getRootFiles());
            return;
        }
        for (VCSFileProxy repository : repositories) {
            GitUtils.logRemoteRepositoryAccess(repository);
            RequestProcessor.Task runningTask = this.performAction(repository, GitUtils.filterForRepository(context, repository), context);
            if (runningTask == null) continue;
            runningTask.waitFinished();
        }
    }

    protected abstract RequestProcessor.Task performAction(VCSFileProxy var1, VCSFileProxy[] var2, VCSContext var3);
}

