/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.tag;

import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitTag;
import org.netbeans.modules.git.remote.client.GitClient;
import org.netbeans.modules.git.remote.client.GitClientExceptionHandler;
import org.netbeans.modules.git.remote.client.GitProgressSupport;
import org.netbeans.modules.git.remote.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.remote.ui.output.OutputLogger;
import org.netbeans.modules.git.remote.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.remote.ui.tag.CreateTag;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.util.NbBundle;

public class CreateTagAction
extends SingleRepositoryAction {
    private static final Logger LOG = Logger.getLogger(CreateTagAction.class.getName());

    @Override
    protected void performAction(VCSFileProxy repository, VCSFileProxy[] roots, VCSContext context) {
        RepositoryInfo info = RepositoryInfo.getInstance(repository);
        this.createTag(repository, info.getActiveBranch().getName().equals("(no branch)") ? "HEAD" : info.getActiveBranch().getName());
    }

    public void createTag(VCSFileProxy repository, String preselectedRevision) {
        final CreateTag createTag = new CreateTag(repository, preselectedRevision, "");
        if (createTag.show()) {
            GitProgressSupport supp = new GitProgressSupport(){

                @Override
                protected void perform() {
                    try {
                        new CreateTagProcess(createTag, this, this.getClient()).call();
                    }
                    catch (GitException ex) {
                        GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                    }
                }
            };
            supp.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(CreateTagAction.class, (String)"LBL_CreateTagAction.progressName"));
        }
    }

    static class CreateTagProcess
    implements Callable<GitTag> {
        private final GitProgressSupport supp;
        private final CreateTag createTag;
        private final GitClient client;

        public CreateTagProcess(CreateTag createTag, GitProgressSupport supp, GitClient client) {
            this.supp = supp;
            this.createTag = createTag;
            this.client = client;
        }

        @Override
        public GitTag call() {
            try {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Creating a tag: {0}/{1}", new Object[]{this.createTag.getTagName(), this.createTag.getRevision()});
                }
                GitTag tag = this.client.createTag(this.createTag.getTagName(), this.createTag.getRevision(), this.createTag.getTagMessage(), false, this.createTag.isForceUpdate(), this.supp.getProgressMonitor());
                this.log(tag);
                return tag;
            }
            catch (GitException ex) {
                GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                return null;
            }
        }

        private void log(GitTag tag) {
            OutputLogger logger = this.supp.getLogger();
            logger.outputLine(NbBundle.getMessage(CreateTagAction.class, (String)"MSG_CreateTagAction.tagCreated", (Object[])new Object[]{tag.getTagName(), tag.getTaggedObjectId(), tag.getTagId(), tag.getTagger().toString(), tag.getMessage()}));
        }
    }
}

