/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.tag;

import java.awt.EventQueue;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitTag;
import org.netbeans.modules.git.remote.client.GitClient;
import org.netbeans.modules.git.remote.client.GitClientExceptionHandler;
import org.netbeans.modules.git.remote.client.GitProgressSupport;
import org.netbeans.modules.git.remote.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.remote.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.remote.ui.tag.ManageTags;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.util.NbBundle;

public class ManageTagsAction
extends SingleRepositoryAction {
    private static final Logger LOG = Logger.getLogger(ManageTagsAction.class.getName());

    @Override
    protected void performAction(VCSFileProxy repository, VCSFileProxy[] roots, VCSContext context) {
        RepositoryInfo info = RepositoryInfo.getInstance(repository);
        this.showTagManager(repository, info.getActiveBranch().getName().equals("(no branch)") ? "HEAD" : info.getActiveBranch().getName());
    }

    public void showTagManager(final VCSFileProxy repository, final String preselectedTag) {
        GitProgressSupport supp = new GitProgressSupport(){

            @Override
            protected void perform() {
                try {
                    GitClient client = this.getClient();
                    Map<String, GitTag> tags = client.getTags(this.getProgressMonitor(), true);
                    final ManageTags createTag = new ManageTags(repository, tags, preselectedTag);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            createTag.show();
                        }
                    });
                }
                catch (GitException ex) {
                    GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                }
            }
        };
        supp.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(ManageTagsAction.class, (String)"LBL_ManageTagsAction.listingTags.progressName"));
    }
}

