/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.hints;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.modules.cnd.api.model.syntaxerr.AuditPreferences;
import org.netbeans.modules.cnd.api.model.syntaxerr.CodeAudit;
import org.netbeans.modules.cnd.api.model.syntaxerr.CodeAuditFactory;
import org.netbeans.modules.cnd.api.model.syntaxerr.CodeAuditProvider;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public final class SuggestionProvider
implements CodeAuditProvider {
    public static final String NAME = "Suggestion";
    private Collection<CodeAudit> audits;
    private final AuditPreferences myPreferences;

    public static CodeAuditProvider getInstance() {
        for (CodeAuditProvider provider : Lookup.getDefault().lookupAll(CodeAuditProvider.class)) {
            if (!NAME.equals(provider.getName())) continue;
            return provider;
        }
        return null;
    }

    public SuggestionProvider() {
        this.myPreferences = new AuditPreferences(AuditPreferences.AUDIT_PREFERENCES_ROOT.node(NAME));
    }

    SuggestionProvider(Preferences preferences) {
        try {
            if (preferences.nodeExists(NAME)) {
                preferences = preferences.node(NAME);
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        this.myPreferences = preferences.absolutePath().endsWith("/Suggestion") ? new AuditPreferences(preferences) : new AuditPreferences(preferences.node(NAME));
    }

    public String getName() {
        return NAME;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(SuggestionProvider.class, (String)"Suggestion_NAME");
    }

    public String getDescription() {
        return NbBundle.getMessage(SuggestionProvider.class, (String)"Suggestion_DESCRIPTION");
    }

    public synchronized Collection<CodeAudit> getAudits() {
        if (this.audits == null) {
            ArrayList<CodeAudit> res = new ArrayList<CodeAudit>();
            for (CodeAuditFactory factory : Lookups.forPath((String)"CND/CndHintsFactory/Suggestion").lookupAll(CodeAuditFactory.class)) {
                res.add((CodeAudit)factory.create(this.myPreferences));
            }
            Collections.sort(res, new Comparator<CodeAudit>(){

                @Override
                public int compare(CodeAudit o1, CodeAudit o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            this.audits = res;
        }
        return this.audits;
    }

    public AuditPreferences getPreferences() {
        return this.myPreferences;
    }

    public String getMimeType() {
        return "text/x-cnd+sourcefile";
    }
}

