/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools.model.query;

import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.jpa.jpql.Assert;
import org.eclipse.persistence.jpa.jpql.parser.Join;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AbstractIdentificationVariableDeclarationStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AbstractStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.CollectionValuedPathExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.IdentificationVariableStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObjectVisitor;
import org.eclipse.persistence.jpa.jpql.utility.iterable.ListIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinStateObject
extends AbstractStateObject {
    private boolean as;
    private IdentificationVariableStateObject identificationVariable;
    private CollectionValuedPathExpressionStateObject joinAssociationPath;
    private String joinType;
    public static final String AS_PROPERTY = "as";
    public static final String JOIN_TYPE_PROPERTY = "joinType";

    public JoinStateObject(AbstractIdentificationVariableDeclarationStateObject parent, String joinType) {
        this(parent, joinType, false);
    }

    public JoinStateObject(AbstractIdentificationVariableDeclarationStateObject parent, String joinType, boolean as) {
        super(parent);
        this.validateJoinType(joinType);
        this.joinType = joinType;
        this.as = as;
    }

    @Override
    public void accept(StateObjectVisitor visitor) {
        visitor.visit(this);
    }

    public JoinStateObject addAs() {
        if (!this.as) {
            this.setAs(true);
        }
        return this;
    }

    @Override
    protected void addChildren(List<StateObject> children) {
        super.addChildren(children);
        children.add(this.joinAssociationPath);
        children.add(this.identificationVariable);
    }

    public void addJoinAssociationPaths(List<String> paths) {
        this.joinAssociationPath.addItems((List<? extends String>)paths);
    }

    @Override
    public Join getExpression() {
        return (Join)super.getExpression();
    }

    public String getIdentificationVariable() {
        return this.identificationVariable.getText();
    }

    public IdentificationVariableStateObject getIdentificationVariableStateObject() {
        return this.identificationVariable;
    }

    public StateObject getJoinAssociationIdentificationVariable() {
        return this.joinAssociationPath.getIdentificationVariable();
    }

    public CollectionValuedPathExpressionStateObject getJoinAssociationPathStateObject() {
        return this.joinAssociationPath;
    }

    public String getJoinType() {
        return this.joinType;
    }

    @Override
    public AbstractIdentificationVariableDeclarationStateObject getParent() {
        return (AbstractIdentificationVariableDeclarationStateObject)super.getParent();
    }

    public boolean hasAs() {
        return this.as;
    }

    public boolean hasFetch() {
        String joinType = this.getJoinType();
        return joinType == "JOIN FETCH" || joinType == "INNER JOIN FETCH" || joinType == "LEFT JOIN FETCH" || joinType == "LEFT OUTER JOIN FETCH";
    }

    public boolean hasIdentificationVariable() {
        return this.identificationVariable.hasText();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.joinAssociationPath = new CollectionValuedPathExpressionStateObject(this);
        this.identificationVariable = new IdentificationVariableStateObject(this);
    }

    @Override
    public boolean isEquivalent(StateObject stateObject) {
        if (super.isEquivalent(stateObject)) {
            JoinStateObject join = (JoinStateObject)stateObject;
            return this.joinType.equals(join.joinType) && this.areEquivalent(this.joinAssociationPath, join.joinAssociationPath) && this.as == join.as && this.identificationVariable.isEquivalent(join.identificationVariable);
        }
        return false;
    }

    public ListIterable<String> joinAssociationPaths() {
        return this.joinAssociationPath.items();
    }

    public int joinAssociationPathSize() {
        return this.joinAssociationPath.itemsSize();
    }

    public void removeNot() {
        if (this.as) {
            this.setAs(false);
        }
    }

    public void setAs(boolean as) {
        boolean oldAs = this.as;
        this.as = as;
        this.firePropertyChanged(AS_PROPERTY, oldAs, as);
    }

    public void setExpression(Join expression) {
        super.setExpression(expression);
    }

    public void setIdentificationVariable(String identificationVariable) {
        this.identificationVariable.setText(identificationVariable);
    }

    public void setJoinAssociationIdentificationVariable(StateObject identificationVariable) {
        this.joinAssociationPath.setIdentificationVariable(identificationVariable);
    }

    public void setJoinAssociationPath(String path) {
        this.joinAssociationPath.setPath(path);
    }

    public void setJoinAssociationPaths(ListIterator<String> paths) {
        this.joinAssociationPath.setPaths(paths);
    }

    public void setJoinAssociationPaths(String[] paths) {
        this.joinAssociationPath.setPaths(paths);
    }

    public void setJoinType(String joinType) {
        this.validateJoinType(joinType);
        String oldJoinType = this.joinType;
        this.joinType = joinType;
        this.firePropertyChanged(JOIN_TYPE_PROPERTY, oldJoinType, joinType);
    }

    public void toggleAs() {
        this.setAs(!this.as);
    }

    @Override
    protected void toTextInternal(Appendable writer) throws IOException {
        writer.append(this.joinType);
        writer.append(' ');
        this.joinAssociationPath.toString(writer);
        writer.append(' ');
        if (this.as) {
            writer.append("AS");
            writer.append(' ');
        }
        this.identificationVariable.toString(writer);
    }

    protected void validateJoinType(String joinType) {
        Assert.isValid(joinType, "The join type is not valid", "JOIN", "LEFT JOIN", "LEFT OUTER JOIN", "INNER JOIN", "JOIN FETCH", "LEFT JOIN FETCH", "LEFT OUTER JOIN FETCH", "INNER JOIN FETCH");
    }
}

