/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.disk;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.netbeans.modules.cnd.repository.api.UnitDescriptor;
import org.netbeans.modules.cnd.repository.impl.spi.UnitDescriptorsList;

public final class UnitDescriptorsListImpl
implements UnitDescriptorsList {
    private final Map<UnitDescriptor, Integer> map = new HashMap<UnitDescriptor, Integer>();
    private final Object lock = new Object();
    private final AtomicInteger counter = new AtomicInteger(0);

    UnitDescriptorsListImpl() {
    }

    void setMaxValue(int max) {
        this.counter.set(max);
    }

    int getMaxValue() {
        return this.counter.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int registerNewUnitDescriptor(UnitDescriptor unitDescriptor) {
        Object object = this.lock;
        synchronized (object) {
            Integer result = this.map.get(unitDescriptor);
            if (result == null) {
                result = this.counter.getAndIncrement();
                this.map.put(unitDescriptor, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addUnitDescriptor(int layerUniID, UnitDescriptor unitDescriptor) {
        Object object = this.lock;
        synchronized (object) {
            this.map.put(unitDescriptor, layerUniID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Integer remove(Integer layerUniID) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.remove(this.getUnitDescriptor(layerUniID));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<UnitDescriptor, Integer> getMap() {
        Object object = this.lock;
        synchronized (object) {
            return Collections.unmodifiableMap(this.map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnitDescriptor getUnitDescriptor(Integer layerUniID) {
        Object object = this.lock;
        synchronized (object) {
            for (Map.Entry<UnitDescriptor, Integer> entry : this.map.entrySet()) {
                if (!entry.getValue().equals(layerUniID)) continue;
                return entry.getKey();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(UnitDescriptor clientUnitDescriptor) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.containsKey(clientUnitDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder("\n[clientUnitDescriptor <-> layerUniID]\n");
        Object object = this.lock;
        synchronized (object) {
            for (Map.Entry<UnitDescriptor, Integer> entry : this.map.entrySet()) {
                sb.append(entry.getKey()).append(" => ").append(entry.getValue()).append("\n");
            }
            return sb.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Integer> getUnitIDs() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.values();
        }
    }
}

