/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.repository.disk.RepositoryImplUtil;
import org.netbeans.modules.cnd.repository.testbench.Stats;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;

public final class IntToValueList<T> {
    public static final CharSequenceFactory CHAR_SEQUENCE_FACTORY = new CharSequenceFactory();
    private final Object cacheLock = new Object();
    private final List<T> cache;
    private final Exception creationStack;
    private final int version;
    private final long timestamp;
    private final transient CharSequence traceName;
    private final transient boolean dummy;

    private IntToValueList(long timestamp, CharSequence traceName, boolean dummy) {
        this.traceName = traceName;
        this.creationStack = Stats.TRACE_IZ_215449 ? new Exception("CREATED " + (dummy ? "INVALID for " : "for ") + traceName + " from Thread=" + Thread.currentThread().getName()) : null;
        this.cache = new ArrayList<T>();
        this.version = RepositoryImplUtil.getVersion();
        this.timestamp = timestamp;
        this.dummy = dummy;
    }

    public static <T> IntToValueList<T> createEmpty(CharSequence unitName) {
        return new IntToValueList<T>(System.currentTimeMillis(), unitName, false);
    }

    public static <T> IntToValueList<T> createDummy(long ts, CharSequence unitName) {
        return new IntToValueList<T>(ts, unitName, true);
    }

    public static <T> IntToValueList<T> createFromStream(DataInput stream, CharSequence unitName, Factory<T> factory) throws IOException {
        return new IntToValueList<T>(stream, unitName, factory);
    }

    private void assertNotDummy() {
        if (this.isDummy() && CndUtils.isDebugMode() && !CndUtils.isUnitTestMode()) {
            new IllegalStateException("ACCESS INVALID cache for " + this.traceName + " Thread=" + Thread.currentThread().getName()).printStackTrace(System.err);
            if (this.creationStack != null) {
                this.creationStack.printStackTrace(System.err);
            }
        }
    }

    private IntToValueList(DataInput stream, CharSequence traceName, Factory<T> factory) throws IOException {
        this.dummy = false;
        this.traceName = traceName;
        Exception exception = this.creationStack = Stats.TRACE_IZ_215449 ? new Exception("DESERIALIZED for " + traceName + " Thread=" + Thread.currentThread().getName()) : null;
        assert (stream != null);
        this.cache = new ArrayList<T>();
        this.version = stream.readInt();
        this.timestamp = stream.readLong();
        int size = stream.readInt();
        for (int i = 0; i < size; ++i) {
            T value = factory.read(stream);
            T v = factory.intern(value);
            this.cache.add(v);
        }
    }

    public List<T> getTable() {
        return new ArrayList<T>(this.cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int id, T value) {
        if (this.cache.size() > id) assert (value.equals(this.cache.get(id)));
        if (this.cache.size() < id) {
            Object object = this.cacheLock;
            synchronized (object) {
                if (this.cache.size() < id) {
                    if (CndUtils.isDebugMode() && !CndUtils.isUnitTestMode()) {
                        CndUtils.assertTrue((boolean)false, (String)("Trying yo add id " + id + " while cache size is " + this.cache.size()));
                    }
                    int delta = id - this.cache.size();
                    for (int i = 0; i < delta; ++i) {
                        this.cache.add(null);
                    }
                }
            }
        }
        this.cache.add(null);
        this.cache.set(id, value);
    }

    public String toString() {
        return (this.dummy ? "INVALID " : "") + "IntToValueCache{" + "version=" + this.version + ", timestamp=" + this.timestamp + ", unitName=" + this.traceName + '}';
    }

    public void write(DataOutput stream) throws IOException {
        this.assertNotDummy();
        assert (this.cache != null);
        assert (stream != null);
        stream.writeInt(this.version);
        stream.writeLong(this.timestamp);
        int size = this.cache.size();
        stream.writeInt(size);
        for (int i = 0; i < size; ++i) {
            T value = this.cache.get(i);
            if (value == null) {
                stream.writeUTF("");
                continue;
            }
            stream.writeUTF(value.toString());
        }
    }

    public boolean isDummy() {
        return this.dummy;
    }

    public T getValueById(int id) {
        this.assertNotDummy();
        return this.cache.get(id);
    }

    public boolean containsId(int id) {
        this.assertNotDummy();
        return 0 <= id && id < this.cache.size();
    }

    public int size() {
        this.assertNotDummy();
        return this.cache.size();
    }

    public int getVersion() {
        this.assertNotDummy();
        return this.version;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Exception getCreationStack() {
        return this.creationStack;
    }

    public static class CharSequenceFactory
    implements Factory<CharSequence> {
        @Override
        public CharSequence intern(CharSequence value) {
            return FilePathCache.getManager().getString(value);
        }

        @Override
        public CharSequence read(DataInput stream) throws IOException {
            return stream.readUTF();
        }
    }

    public static interface Factory<T> {
        public T intern(T var1);

        public T read(DataInput var1) throws IOException;
    }
}

