/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.callgraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmCompoundClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFriend;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.services.CsmCacheManager;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.services.CsmFileReferences;
import org.netbeans.modules.cnd.api.model.services.CsmReferenceContext;
import org.netbeans.modules.cnd.api.model.services.CsmVirtualInfoQuery;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceRepository;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.callgraph.api.Call;
import org.netbeans.modules.cnd.callgraph.api.CallModel;
import org.netbeans.modules.cnd.callgraph.api.Function;
import org.netbeans.modules.cnd.callgraph.api.ui.CallGraphPreferences;
import org.netbeans.modules.cnd.navigation.callgraph.CallImpl;
import org.netbeans.modules.cnd.navigation.callgraph.FunctionImpl;
import org.netbeans.modules.cnd.navigation.callgraph.VariableImpl;
import org.netbeans.modules.cnd.support.Interrupter;

public class CallModelImpl
implements CallModel {
    private final CsmReferenceRepository repository = CsmReferenceRepository.getDefault();
    private final CsmFileReferences fileReferences = CsmFileReferences.getDefault();
    private final CsmProject project;
    private String name;
    private DeclarationUIN uin;

    public CallModelImpl(CsmProject project, CsmOffsetableDeclaration root) {
        this.project = project;
        this.uin = new DeclarationUIN(project, root);
        this.name = root.getName().toString();
    }

    public Function getRoot() {
        CsmOffsetableDeclaration root = this.uin.getDeclaration();
        if (root != null) {
            CsmCacheManager.enter();
            try {
                Function function = CallModelImpl.implementationResolver(root);
                return function;
            }
            finally {
                CsmCacheManager.leave();
            }
        }
        return null;
    }

    public boolean isRootVisible() {
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setRoot(Function newRoot) {
        VariableImpl impl;
        CsmOffsetableDeclaration v;
        if (newRoot instanceof FunctionImpl) {
            FunctionImpl impl2 = (FunctionImpl)newRoot;
            CsmFunction f = impl2.getDefinition();
            if (f != null) {
                this.uin = new DeclarationUIN(this.project, (CsmOffsetableDeclaration)f);
                this.name = f.getName().toString();
            }
        } else if (newRoot instanceof VariableImpl && (v = (impl = (VariableImpl)newRoot).getVariable()) != null) {
            this.uin = new DeclarationUIN(this.project, v);
            this.name = v.getName().toString();
        }
    }

    public void update() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Call> getCallers(Function declaration) {
        CsmCacheManager.enter();
        try {
            Object owner;
            CsmFunction o;
            ArrayList<Object> declarations = new ArrayList<Object>();
            ArrayList<Call> res = new ArrayList<Call>();
            if (declaration instanceof FunctionImpl) {
                FunctionImpl functionImpl = (FunctionImpl)declaration;
                CsmFunction owner2 = functionImpl.getDeclaration();
                declarations.add(owner2);
                if (CallGraphPreferences.isShowOverriding() && CsmKindUtilities.isMethodDeclaration((CsmObject)owner2)) {
                    Collection overrides = CsmVirtualInfoQuery.getDefault().getAllBaseDeclarations((CsmMethod)owner2);
                    declarations.addAll(overrides);
                }
            } else if (declaration instanceof VariableImpl) {
                declarations.add(((VariableImpl)declaration).getVariable());
            } else {
                ArrayList<Call> functionImpl = res;
                return functionImpl;
            }
            EnumSet<CsmReferenceKind> kinds = declaration instanceof FunctionImpl ? EnumSet.of(CsmReferenceKind.DIRECT_USAGE, CsmReferenceKind.UNKNOWN) : EnumSet.of(CsmReferenceKind.DIRECT_USAGE, CsmReferenceKind.UNKNOWN, CsmReferenceKind.DECLARATION);
            HashMap set = new HashMap();
            HashMap<CsmMacro, CsmReference> macros = new HashMap<CsmMacro, CsmReference>();
            for (CsmOffsetableDeclaration csmOffsetableDeclaration : declarations) {
                if (!csmOffsetableDeclaration.getContainingFile().isValid()) continue;
                for (CsmReference csmReference : this.repository.getReferences((CsmObject)csmOffsetableDeclaration, this.project, CsmReferenceKind.ANY_REFERENCE_IN_ACTIVE_CODE, Interrupter.DUMMY)) {
                    if (csmReference == null || !CsmReferenceResolver.getDefault().isKindOf(csmReference, kinds)) continue;
                    o = this.getFunctionDeclaration(this.getEnclosingFunction(csmReference));
                    if (o != null) {
                        if (!set.containsKey(o)) {
                            set.put(o, new ArrayList());
                        }
                        ((ArrayList)set.get(o)).add(csmReference);
                        continue;
                    }
                    CsmMacro enclosingMacro = this.getEnclosingMacro(csmReference);
                    if (enclosingMacro == null || macros.containsKey(enclosingMacro)) continue;
                    macros.put(enclosingMacro, csmReference);
                }
            }
            for (Map.Entry entry : macros.entrySet()) {
                for (CsmReference csmReference : this.repository.getReferences((CsmObject)entry.getKey(), this.project, CsmReferenceKind.ANY_REFERENCE_IN_ACTIVE_CODE, Interrupter.DUMMY)) {
                    if (csmReference == null || !CsmReferenceResolver.getDefault().isKindOf(csmReference, kinds) || (o = this.getFunctionDeclaration(this.getEnclosingFunction(csmReference))) == null) continue;
                    if (!set.containsKey(o)) {
                        set.put(o, new ArrayList());
                    }
                    ((ArrayList)set.get(o)).add(csmReference);
                }
            }
            if (declaration instanceof FunctionImpl) {
                FunctionImpl functionImpl = (FunctionImpl)declaration;
                owner = functionImpl.getDeclaration();
            } else {
                owner = declaration instanceof VariableImpl ? ((VariableImpl)declaration).getVariable() : null;
            }
            CsmFunction csmFunction = owner;
            if (csmFunction != null) {
                for (Map.Entry entry : set.entrySet()) {
                    res.add(new CallImpl((CsmOffsetableDeclaration)entry.getKey(), (ArrayList)entry.getValue(), (CsmOffsetableDeclaration)csmFunction, true));
                }
            }
            Iterator<Object> iterator = res;
            return iterator;
        }
        finally {
            CsmCacheManager.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Call> getCallees(Function definition) {
        CsmCacheManager.enter();
        try {
            if (definition instanceof VariableImpl) {
                ArrayList<Call> arrayList = new ArrayList<Call>();
                return arrayList;
            }
            if (definition instanceof FunctionImpl) {
                FunctionImpl definitionImpl = (FunctionImpl)definition;
                CsmFunction owner = definitionImpl.getDefinition();
                ArrayList<CsmFunction> functions = new ArrayList<CsmFunction>();
                functions.add(owner);
                if (CallGraphPreferences.isShowOverriding() && CsmKindUtilities.isMethodDeclaration((CsmObject)owner)) {
                    Collection overrides = CsmVirtualInfoQuery.getDefault().getOverriddenMethods((CsmMethod)owner, false);
                    functions.addAll(overrides);
                }
                ArrayList<CallImpl> res = new ArrayList<CallImpl>();
                final HashMap set = new HashMap();
                for (CsmFunction function : functions) {
                    if (!CsmKindUtilities.isFunctionDefinition((CsmObject)function) || !function.getContainingFile().isValid()) continue;
                    final List list = CsmFileInfoQuery.getDefault().getUnusedCodeBlocks(function.getContainingFile(), Interrupter.DUMMY);
                    this.fileReferences.accept((CsmScope)function, null, new CsmFileReferences.Visitor(){

                        public void visit(CsmReferenceContext context) {
                            CsmReference r = context.getReference();
                            if (r == null) {
                                return;
                            }
                            for (CsmOffsetable offset : list) {
                                if (offset.getStartOffset() > r.getStartOffset() || offset.getEndOffset() < r.getEndOffset()) continue;
                                return;
                            }
                            try {
                                CsmObject o = r.getReferencedObject();
                                if (CsmKindUtilities.isFunction((CsmObject)o) && !CsmReferenceResolver.getDefault().isKindOf(r, CsmReferenceKind.FUNCTION_DECLARATION_KINDS)) {
                                    if (!set.containsKey((CsmOffsetableDeclaration)(o = CallModelImpl.this.getFunctionDeclaration((CsmFunction)o)))) {
                                        set.put((CsmOffsetableDeclaration)o, new ArrayList());
                                    }
                                    ((ArrayList)set.get((CsmOffsetableDeclaration)o)).add(r);
                                } else if (CsmKindUtilities.isVariable((CsmObject)o) && CsmKindUtilities.isFunctionPointerType((CsmObject)((CsmVariable)o).getType())) {
                                    if (!set.containsKey((CsmOffsetableDeclaration)o)) {
                                        set.put((CsmOffsetableDeclaration)o, new ArrayList());
                                    }
                                    ((ArrayList)set.get((CsmOffsetableDeclaration)o)).add(r);
                                }
                            }
                            catch (AssertionError e) {
                                ((Throwable)((Object)e)).printStackTrace(System.err);
                            }
                            catch (Exception e) {
                                e.printStackTrace(System.err);
                            }
                        }

                        public boolean cancelled() {
                            return false;
                        }
                    }, CsmReferenceKind.ANY_REFERENCE_IN_ACTIVE_CODE);
                }
                CsmFunction functionDeclaration = this.getFunctionDeclaration(owner);
                if (functionDeclaration != null) {
                    for (Map.Entry entry : set.entrySet()) {
                        res.add(new CallImpl((CsmOffsetableDeclaration)functionDeclaration, (ArrayList)entry.getValue(), (CsmOffsetableDeclaration)entry.getKey(), false));
                    }
                }
                ArrayList<CallImpl> arrayList = res;
                return arrayList;
            }
            ArrayList<Call> arrayList = new ArrayList<Call>();
            return arrayList;
        }
        finally {
            CsmCacheManager.leave();
        }
    }

    private CsmFunction getFunctionDeclaration(CsmFunction definition) {
        if (definition != null && CsmKindUtilities.isFunctionDefinition((CsmObject)definition)) {
            return ((CsmFunctionDefinition)definition).getDeclaration();
        }
        return definition;
    }

    private CsmMacro getEnclosingMacro(CsmReference ref) {
        CsmObject o = ref.getClosestTopLevelObject();
        if (CsmKindUtilities.isMacro((CsmObject)o)) {
            return (CsmMacro)o;
        }
        return null;
    }

    private CsmFunction getEnclosingFunction(CsmReference ref) {
        CsmObject o = ref.getClosestTopLevelObject();
        if (CsmKindUtilities.isFunction((CsmObject)o)) {
            return (CsmFunction)o;
        }
        return null;
    }

    private static Function implementationResolver(CsmOffsetableDeclaration entity) {
        if (CsmKindUtilities.isFunction((CsmObject)entity)) {
            return new FunctionImpl((CsmFunction)entity);
        }
        if (CsmKindUtilities.isVariable((CsmObject)entity)) {
            return new VariableImpl((CsmOffsetableDeclaration)((CsmVariable)entity));
        }
        if (CsmKindUtilities.isEnumerator((Object)entity)) {
            return new VariableImpl((CsmOffsetableDeclaration)((CsmEnumerator)entity));
        }
        return null;
    }

    private static class DeclarationUIN {
        private final CsmProject project;
        private final CharSequence declarationUin;
        private final CsmUID<CsmFile> fileUid;

        private DeclarationUIN(CsmProject project, CsmOffsetableDeclaration declaration) {
            this.project = project;
            this.fileUid = UIDs.get((Object)declaration.getContainingFile());
            this.declarationUin = declaration.getUniqueName();
        }

        private CsmOffsetableDeclaration getDeclaration() {
            if (!this.project.isValid()) {
                return null;
            }
            for (CsmOffsetableDeclaration decl : this.project.findDeclarations(this.declarationUin)) {
                CsmFile containingFile = decl.getContainingFile();
                if (containingFile == null || !this.fileUid.equals((Object)UIDs.get((Object)decl.getContainingFile()))) continue;
                return decl;
            }
            CsmFile file = (CsmFile)this.fileUid.getObject();
            if (!file.isValid()) {
                return null;
            }
            for (CsmDeclaration d : file.getDeclarations()) {
                CsmOffsetableDeclaration root = this.findDeclaration(d);
                if (root == null) continue;
                return root;
            }
            return null;
        }

        private CsmOffsetableDeclaration findDeclaration(CsmDeclaration element) {
            CsmEnumerator var;
            if (CsmKindUtilities.isTypedef((CsmObject)element) || CsmKindUtilities.isTypeAlias((CsmObject)element)) {
                CsmClassifier cls;
                CsmTypedef def = (CsmTypedef)element;
                if (def.isTypeUnnamed() && (cls = def.getType().getClassifier()) != null && cls.getName().length() == 0 && cls instanceof CsmCompoundClassifier) {
                    return this.findDeclaration((CsmDeclaration)((CsmCompoundClassifier)cls));
                }
                return null;
            }
            if (CsmKindUtilities.isClassifier((CsmObject)element)) {
                CsmClass cls;
                Collection list;
                String name = ((CsmClassifier)element).getName().toString();
                if (name.length() == 0 && element instanceof CsmCompoundClassifier && (list = ((CsmCompoundClassifier)element).getEnclosingTypedefs()).size() > 0) {
                    return null;
                }
                if (CsmKindUtilities.isClass((CsmObject)element)) {
                    CsmOffsetableDeclaration res;
                    cls = (CsmClass)element;
                    for (CsmMember member : cls.getMembers()) {
                        res = this.findDeclaration((CsmDeclaration)member);
                        if (res == null) continue;
                        return res;
                    }
                    for (CsmFriend friend : cls.getFriends()) {
                        res = this.findDeclaration((CsmDeclaration)friend);
                        if (res == null) continue;
                        return res;
                    }
                } else if (CsmKindUtilities.isEnum((CsmObject)element)) {
                    cls = (CsmEnum)element;
                    for (CsmEnumerator member : cls.getEnumerators()) {
                        CsmOffsetableDeclaration res = this.findDeclaration((CsmDeclaration)member);
                        if (res == null) continue;
                        return res;
                    }
                }
                return null;
            }
            if (CsmKindUtilities.isNamespaceDefinition((CsmObject)element)) {
                for (CsmDeclaration d : ((CsmNamespaceDefinition)element).getDeclarations()) {
                    CsmOffsetableDeclaration res = this.findDeclaration(d);
                    if (res == null) continue;
                    return res;
                }
            } else if (CsmKindUtilities.isFunction((CsmObject)element)) {
                if (element.getUniqueName().equals(this.declarationUin)) {
                    return (CsmOffsetableDeclaration)element;
                }
            } else if (CsmKindUtilities.isVariableDeclaration((CsmObject)element)) {
                CsmVariable var2 = (CsmVariable)element;
                if (var2.getUniqueName().equals(this.declarationUin)) {
                    return var2;
                }
            } else if (CsmKindUtilities.isEnumerator((Object)element) && (var = (CsmEnumerator)element).getUniqueName().equals(this.declarationUin)) {
                return var;
            }
            return null;
        }
    }
}

