/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.api.InvertBooleanRefactoring;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.plugins.Bundle;
import org.netbeans.modules.refactoring.java.plugins.FindVisitor;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.plugins.ReplaceConstructorWithBuilderPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.spi.java.hints.support.TransformationSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;

public class InvertBooleanRefactoringPlugin
implements RefactoringPlugin {
    private final InvertBooleanRefactoring invertBooleanRefactoring;
    protected final AtomicBoolean cancel = new AtomicBoolean();
    private static final String INVERT_FIXES = "=> ${newName-with-enclosing}$ $left != $right; :: matchesWithBind($val, \"$left == $right\")\n=> ${newName-with-enclosing}$ $left == $right; :: matchesWithBind($val, \"$left != $right\")\n=> ${newName-with-enclosing}$ $op; :: matchesWithBind($val, \"!($op)\")=> ${newName-with-enclosing}$ $op; :: matchesWithBind($val, \"(!$op)\")=> ${newName-with-enclosing}$ $op; :: !matchesAny($val, \"!($op)\") && matchesWithBind($val, \"!$op\")\n=> ${newName-with-enclosing}$ false; :: matchesAny($val, \"true\")\n=> ${newName-with-enclosing}$ true; :: matchesAny($val, \"false\")\n=> ${newName-with-enclosing}$ !$val; :: otherwise\n";
    private static final String VAR_SCRIPT_TEMPLATE = "   $enclosing.${originalName}$ :: $enclosing instanceof ${enclosing}$ && !parentMatches(\"$enclosing.${originalName}$ = $newVal\") && !parentMatches(\"!$enclosing.${originalName}$\")\n=> !$enclosing.${newName}$\n;;\n   !$enclosing.${originalName}$ :: $enclosing instanceof ${enclosing}$\n=> $enclosing.${newName}$\n;;\n   $enclosing.${originalName}$ = $val :: $enclosing instanceof ${enclosing}$ && !matchesAny($val, \"!$enclosing.${originalName}$\")\n" + "=> ${newName-with-enclosing}$ $left != $right; :: matchesWithBind($val, \"$left == $right\")\n=> ${newName-with-enclosing}$ $left == $right; :: matchesWithBind($val, \"$left != $right\")\n=> ${newName-with-enclosing}$ $op; :: matchesWithBind($val, \"!($op)\")=> ${newName-with-enclosing}$ $op; :: matchesWithBind($val, \"(!$op)\")=> ${newName-with-enclosing}$ $op; :: !matchesAny($val, \"!($op)\") && matchesWithBind($val, \"!$op\")\n=> ${newName-with-enclosing}$ false; :: matchesAny($val, \"true\")\n=> ${newName-with-enclosing}$ true; :: matchesAny($val, \"false\")\n=> ${newName-with-enclosing}$ !$val; :: otherwise\n".replace(";", "").replace("${newName-with-enclosing}$", "$enclosing.${newName}$ =") + ";;\n";
    private static final String VAR_SCRIPT_TEMPLATE_STATIC = "   ${enclosing}$.${originalName}$ :: !parentMatches(\"$enclosing.${originalName}$ = $newVal\") && !parentMatches(\"!$enclosing.${originalName}$\")\n=> !${enclosing}$.${newName}$\n;;\n   !${enclosing}$.${originalName}$\n=> ${enclosing}$.${newName}$\n;;\n   ${enclosing}$.${originalName}$ = $val :: !matchesAny($val, \"!$enclosing.${originalName}$\")\n" + "=> ${newName-with-enclosing}$ $left != $right; :: matchesWithBind($val, \"$left == $right\")\n=> ${newName-with-enclosing}$ $left == $right; :: matchesWithBind($val, \"$left != $right\")\n=> ${newName-with-enclosing}$ $op; :: matchesWithBind($val, \"!($op)\")=> ${newName-with-enclosing}$ $op; :: matchesWithBind($val, \"(!$op)\")=> ${newName-with-enclosing}$ $op; :: !matchesAny($val, \"!($op)\") && matchesWithBind($val, \"!$op\")\n=> ${newName-with-enclosing}$ false; :: matchesAny($val, \"true\")\n=> ${newName-with-enclosing}$ true; :: matchesAny($val, \"false\")\n=> ${newName-with-enclosing}$ !$val; :: otherwise\n".replace(";", "").replace("${newName-with-enclosing}$", "${enclosing}$.${newName}$ =") + ";;\n";
    private static final String VAR_INIT = "   $mods$ $type ${originalName}$ = $val;" + "=> ${newName-with-enclosing}$ $left != $right; :: matchesWithBind($val, \"$left == $right\")\n=> ${newName-with-enclosing}$ $left == $right; :: matchesWithBind($val, \"$left != $right\")\n=> ${newName-with-enclosing}$ $op; :: matchesWithBind($val, \"!($op)\")=> ${newName-with-enclosing}$ $op; :: matchesWithBind($val, \"(!$op)\")=> ${newName-with-enclosing}$ $op; :: !matchesAny($val, \"!($op)\") && matchesWithBind($val, \"!$op\")\n=> ${newName-with-enclosing}$ false; :: matchesAny($val, \"true\")\n=> ${newName-with-enclosing}$ true; :: matchesAny($val, \"false\")\n=> ${newName-with-enclosing}$ !$val; :: otherwise\n".replace("${newName-with-enclosing}$", "$mods$ $type ${newName}$  =") + ";;";
    private static final String MTH_INIT = "   return $val;" + "=> ${newName-with-enclosing}$ $left != $right; :: matchesWithBind($val, \"$left == $right\")\n=> ${newName-with-enclosing}$ $left == $right; :: matchesWithBind($val, \"$left != $right\")\n=> ${newName-with-enclosing}$ $op; :: matchesWithBind($val, \"!($op)\")=> ${newName-with-enclosing}$ $op; :: matchesWithBind($val, \"(!$op)\")=> ${newName-with-enclosing}$ $op; :: !matchesAny($val, \"!($op)\") && matchesWithBind($val, \"!$op\")\n=> ${newName-with-enclosing}$ false; :: matchesAny($val, \"true\")\n=> ${newName-with-enclosing}$ true; :: matchesAny($val, \"false\")\n=> ${newName-with-enclosing}$ !$val; :: otherwise\n".replace("${newName-with-enclosing}$", "return ") + ";;";

    public InvertBooleanRefactoringPlugin(InvertBooleanRefactoring invertBooleanRefactoring) {
        this.invertBooleanRefactoring = invertBooleanRefactoring;
    }

    public Problem preCheck() {
        final TreePathHandle treePathHandle = (TreePathHandle)this.invertBooleanRefactoring.getRefactoringSource().lookup(TreePathHandle.class);
        JavaSource js = JavaSource.forFileObject((FileObject)treePathHandle.getFileObject());
        if (js == null) {
            return null;
        }
        final Problem[] preCheckProblem = new Problem[]{null};
        try {
            js.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController javac) throws Exception {
                    javac.toPhase(JavaSource.Phase.RESOLVED);
                    Element element = treePathHandle.resolveElement((CompilationInfo)javac);
                    preCheckProblem[0] = InvertBooleanRefactoringPlugin.this.isElementAvail(treePathHandle, (CompilationInfo)javac);
                    if (preCheckProblem[0] != null) {
                        return;
                    }
                    preCheckProblem[0] = JavaPluginUtils.isSourceElement(element, (CompilationInfo)javac);
                    if (preCheckProblem[0] != null) {
                        return;
                    }
                    switch (element.getKind()) {
                        case METHOD: {
                            if (element.getEnclosingElement().getKind().isInterface()) {
                                preCheckProblem[0] = InvertBooleanRefactoringPlugin.this.createProblem(preCheckProblem[0], true, Bundle.ERR_InvertMethodInInterface());
                                return;
                            }
                            if (element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                                preCheckProblem[0] = InvertBooleanRefactoringPlugin.this.createProblem(preCheckProblem[0], true, Bundle.ERR_InvertMethodAbstract());
                                return;
                            }
                            Collection<ExecutableElement> overridenMethods = JavaRefactoringUtils.getOverriddenMethods((ExecutableElement)element, (CompilationInfo)javac);
                            Collection<ExecutableElement> overridingMethods = JavaRefactoringUtils.getOverridingMethods((ExecutableElement)element, (CompilationInfo)javac, new AtomicBoolean());
                            if (overridenMethods.size() <= 0 && overridingMethods.size() <= 0) break;
                            preCheckProblem[0] = InvertBooleanRefactoringPlugin.this.createProblem(preCheckProblem[0], true, Bundle.ERR_InvertMethodPolymorphic());
                            return;
                        }
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return preCheckProblem[0];
    }

    private Problem createProblem(Problem result, boolean isFatal, String message) {
        Problem problem = new Problem(isFatal, message);
        return JavaPluginUtils.chainProblems(result, problem);
    }

    private Problem isElementAvail(TreePathHandle e, CompilationInfo info) {
        String elName;
        if (e == null) {
            return new Problem(true, NbBundle.getMessage(FindVisitor.class, (String)"DSC_ElNotAvail"));
        }
        Element el = e.resolveElement(info);
        String string = elName = el != null ? el.getSimpleName().toString() : null;
        if (el == null || el.asType().getKind() == TypeKind.ERROR || "<error>".equals(elName)) {
            return new Problem(true, NbBundle.getMessage(FindVisitor.class, (String)"DSC_ElementNotResolved"));
        }
        if ("this".equals(elName) || "super".equals(elName)) {
            return new Problem(true, NbBundle.getMessage(FindVisitor.class, (String)"ERR_CannotRefactorThis", (Object)el.getSimpleName()));
        }
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        String name = this.invertBooleanRefactoring.getNewName();
        if (name == null || name.length() == 0 || !SourceVersion.isIdentifier(name)) {
            return new Problem(true, NbBundle.getMessage(InvertBooleanRefactoringPlugin.class, (String)"ERR_InvalidIdentifier", (Object)name));
        }
        return null;
    }

    public final Problem prepare(RefactoringElementsBag refactoringElements) {
        this.cancel.set(false);
        final TreePathHandle original = (TreePathHandle)this.invertBooleanRefactoring.getRefactoringSource().lookup(TreePathHandle.class);
        final String[] ruleCode = new String[1];
        String[] toCode = new String[1];
        try {
            ModificationResult mod = JavaSource.forFileObject((FileObject)original.getFileObject()).runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(final WorkingCopy parameter) throws Exception {
                    String scriptTemplate;
                    parameter.toPhase(JavaSource.Phase.RESOLVED);
                    TreePath path = original.resolve((CompilationInfo)parameter);
                    HashMap<String, String> arguments = new HashMap<String, String>();
                    Tree leaf = path.getLeaf();
                    TypeElement parent = (TypeElement)parameter.getTrees().getElement(path.getParentPath());
                    arguments.put("newName", InvertBooleanRefactoringPlugin.this.invertBooleanRefactoring.getNewName());
                    arguments.put("enclosing", parent.getQualifiedName().toString());
                    if (leaf.getKind() == Tree.Kind.VARIABLE) {
                        VariableTree var = (VariableTree)leaf;
                        scriptTemplate = var.getModifiers().getFlags().contains((Object)Modifier.STATIC) ? VAR_SCRIPT_TEMPLATE_STATIC : VAR_SCRIPT_TEMPLATE;
                        arguments.put("originalName", var.getName().toString());
                        if (var.getInitializer() != null) {
                            MapFormat format = new MapFormat(arguments);
                            format.setLeftBrace("${");
                            format.setRightBrace("}$");
                            String initFormat = format.format((Object)VAR_INIT);
                            TransformationSupport.create((String)initFormat).setCancel(InvertBooleanRefactoringPlugin.this.cancel).transformTreePath(parameter, path);
                        }
                    } else if (leaf.getKind() == Tree.Kind.METHOD) {
                        MethodTree mt = (MethodTree)leaf;
                        arguments.put("originalName", mt.getName().toString());
                        MapFormat format = new MapFormat(arguments);
                        format.setLeftBrace("${");
                        format.setRightBrace("}$");
                        final String mthFormat = format.format((Object)MTH_INIT);
                        new TreePathScanner<Void, Void>(){

                            @Override
                            public Void visitReturn(ReturnTree node, Void p) {
                                TransformationSupport.create((String)mthFormat).setCancel(InvertBooleanRefactoringPlugin.this.cancel).transformTreePath(parameter, this.getCurrentPath());
                                return (Void)super.visitReturn(node, p);
                            }

                            @Override
                            public Void visitClass(ClassTree node, Void p) {
                                return null;
                            }
                        }.scan(path, (Void)null);
                        parameter.rewrite(leaf, parameter.getTreeMaker().setLabel(leaf, (CharSequence)InvertBooleanRefactoringPlugin.this.invertBooleanRefactoring.getNewName()));
                        StringBuilder parameters = new StringBuilder();
                        StringBuilder constraints = new StringBuilder();
                        int count = 1;
                        for (VariableTree variableTree : mt.getParameters()) {
                            if (count > 1) {
                                parameters.append(", ");
                                constraints.append(" && ");
                            }
                            parameters.append("$").append(count);
                            TypeMirror type = parameter.getTrees().getTypeMirror(new TreePath(new TreePath(path, variableTree), variableTree.getType()));
                            type = parameter.getTypes().erasure(type);
                            constraints.append("$").append(count).append(" instanceof ").append(type);
                            ++count;
                        }
                        String andConstraints = (constraints.length() > 0 ? " && " : "") + constraints;
                        StringBuilder stringBuilder = new StringBuilder();
                        if (mt.getModifiers().getFlags().contains((Object)Modifier.STATIC)) {
                            stringBuilder.append("   ${enclosing}$.<$T$>${originalName}$(").append((CharSequence)parameters).append(") :: !parentMatches(\"!$enclosing.${originalName}$($args$)\")").append(andConstraints);
                            stringBuilder.append("=> !${enclosing}$.<$T$>${newName}$(").append((CharSequence)parameters).append(") :: !parentMatches(\"$enclosing.${originalName}$($args$);\")");
                            stringBuilder.append("=> ${enclosing}$.<$T$>${newName}$(").append((CharSequence)parameters).append(")\n");
                            stringBuilder.append(";;\n");
                            stringBuilder.append("   !${enclosing}$.<$T$>${originalName}$(").append((CharSequence)parameters).append(") :: ").append((CharSequence)constraints);
                            stringBuilder.append("=> ${enclosing}$.<$T$>${newName}$(").append((CharSequence)parameters).append(")\n");
                            stringBuilder.append(";;\n");
                        } else {
                            stringBuilder.append("   $enclosing.<$T$>${originalName}$(").append((CharSequence)parameters).append(") :: $enclosing instanceof ${enclosing}$ && !parentMatches(\"!$enclosing.${originalName}$($args$)\")").append(andConstraints);
                            stringBuilder.append("=> !$enclosing.<$T$>${newName}$(").append((CharSequence)parameters).append(") :: !parentMatches(\"$enclosing.${originalName}$($args$);\")");
                            stringBuilder.append("=> $enclosing.<$T$>${newName}$(").append((CharSequence)parameters).append(")\n");
                            stringBuilder.append(";;\n");
                            stringBuilder.append("   !$enclosing.<$T$>${originalName}$(").append((CharSequence)parameters).append(") :: $enclosing instanceof ${enclosing}$ ").append(andConstraints);
                            stringBuilder.append("=> $enclosing.<$T$>${newName}$(").append((CharSequence)parameters).append(")\n");
                            stringBuilder.append(";;\n");
                        }
                        scriptTemplate = stringBuilder.toString();
                    } else {
                        throw new UnsupportedOperationException();
                    }
                    MapFormat format = new MapFormat(arguments);
                    format.setLeftBrace("${");
                    format.setRightBrace("}$");
                    ruleCode[0] = format.format((Object)scriptTemplate);
                }
            });
            ArrayList<ModificationResult> results = new ArrayList<ModificationResult>();
            results.add(mod);
            results.addAll(TransformationSupport.create((String)ruleCode[0]).setCancel(this.cancel).processAllProjects());
            ReplaceConstructorWithBuilderPlugin.createAndAddElements(this.invertBooleanRefactoring, refactoringElements, results);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    public void cancelRequest() {
        this.cancel.set(true);
    }
}

