/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.visualeditor.querymodel;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Column;
import org.netbeans.modules.db.sql.visualeditor.querymodel.ColumnItem;
import org.netbeans.modules.db.sql.visualeditor.querymodel.ColumnNode;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Select;

public class SelectNode
implements Select {
    private ArrayList _selectItemList;
    private String _quantifier;

    public SelectNode() {
    }

    public SelectNode(ArrayList columnList, String quantifier) {
        this._selectItemList = columnList;
        this._quantifier = quantifier;
    }

    public SelectNode(ArrayList columnList) {
        this(columnList, "");
    }

    @Override
    public String genText(SQLIdentifiers.Quoter quoter) {
        String res = "";
        String res_select_quantifier = "";
        if (this._selectItemList.size() > 0) {
            res_select_quantifier = this._quantifier.length() == 0 ? "SELECT " : "SELECT " + this._quantifier + " ";
            res = res_select_quantifier + ((ColumnItem)this._selectItemList.get(0)).genText(quoter, true);
            for (int i = 1; i < this._selectItemList.size(); ++i) {
                ColumnItem col = (ColumnItem)this._selectItemList.get(i);
                if (col == null) continue;
                res = res + ", " + col.genText(quoter, true);
            }
        }
        return res;
    }

    public void setColumnList(ArrayList columnList) {
        this._selectItemList = columnList;
    }

    @Override
    public void getReferencedColumns(Collection columns) {
        for (int i = 0; i < this._selectItemList.size(); ++i) {
            columns.add(((ColumnItem)this._selectItemList.get(i)).getReferencedColumn());
        }
    }

    @Override
    public int getSize() {
        return this._selectItemList.size();
    }

    public void addColumn(Column col) {
        this._selectItemList.add(col);
    }

    public void addColumn(String tableSpec, String columnName) {
        this._selectItemList.add(new ColumnNode(tableSpec, columnName));
    }

    public void removeColumn(String tableSpec, String columnName) {
        for (int i = this._selectItemList.size() - 1; i >= 0; --i) {
            ColumnItem item = (ColumnItem)this._selectItemList.get(i);
            ColumnNode c = (ColumnNode)item.getReferencedColumn();
            if (c == null || !c.getTableSpec().equals(tableSpec) || !c.getColumnName().equals(columnName)) continue;
            this._selectItemList.remove(i);
        }
    }

    public void setColumnName(String oldColumnName, String newColumnName) {
        for (int i = 0; i < this._selectItemList.size(); ++i) {
            ColumnNode c = (ColumnNode)this._selectItemList.get(i);
            if (c == null) continue;
            c.setColumnName(oldColumnName, newColumnName);
        }
    }

    public boolean hasAsteriskQualifier() {
        for (int i = 0; i < this._selectItemList.size(); ++i) {
            ColumnNode c;
            ColumnItem item = (ColumnItem)this._selectItemList.get(i);
            if (!(item instanceof ColumnNode) || !(c = (ColumnNode)item).getColumnName().equals("*")) continue;
            return true;
        }
        return false;
    }

    void removeTable(String tableSpec) {
        for (int i = this._selectItemList.size() - 1; i >= 0; --i) {
            String tabSpec;
            ColumnItem item = (ColumnItem)this._selectItemList.get(i);
            ColumnNode c = (ColumnNode)item.getReferencedColumn();
            if (c == null || (tabSpec = c.getTableSpec()) == null || !tabSpec.equals(tableSpec)) continue;
            this._selectItemList.remove(i);
        }
    }

    void renameTableSpec(String oldTableSpec, String corrName) {
        for (int i = 0; i < this._selectItemList.size(); ++i) {
            ColumnItem item = (ColumnItem)this._selectItemList.get(i);
            ColumnNode c = (ColumnNode)item.getReferencedColumn();
            if (c == null) continue;
            c.renameTableSpec(oldTableSpec, corrName);
        }
    }
}

