/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.algorithms;

import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class JCEMapper {
    static Logger log = Logger.getLogger(JCEMapper.class.getName());
    private static Map uriToJCEName;
    private static Map algorithmsMap;
    private static String providerName;

    public static void init(Element element) throws Exception {
        JCEMapper.loadAlgorithms((Element)element.getElementsByTagName("Algorithms").item(0));
    }

    static void loadAlgorithms(Element element) {
        Element[] elementArray = XMLUtils.selectNodes(element.getFirstChild(), "http://www.xmlsecurity.org/NS/#configuration", "Algorithm");
        uriToJCEName = new HashMap(elementArray.length * 2);
        algorithmsMap = new HashMap(elementArray.length * 2);
        for (int i = 0; i < elementArray.length; ++i) {
            Element element2 = elementArray[i];
            String string2 = element2.getAttribute("URI");
            String string3 = element2.getAttribute("JCEName");
            uriToJCEName.put(string2, string3);
            algorithmsMap.put(string2, new Algorithm(element2));
        }
    }

    static Algorithm getAlgorithmMapping(String string2) {
        return (Algorithm)algorithmsMap.get(string2);
    }

    public static String translateURItoJCEID(String string2) {
        log.log(Level.FINE, "Request for URI " + string2);
        String string3 = (String)uriToJCEName.get(string2);
        return string3;
    }

    public static String getAlgorithmClassFromURI(String string2) {
        log.log(Level.FINE, "Request for URI " + string2);
        return ((Algorithm)JCEMapper.algorithmsMap.get((Object)string2)).algorithmClass;
    }

    public static int getKeyLengthFromURI(String string2) {
        return Integer.parseInt(((Algorithm)JCEMapper.algorithmsMap.get((Object)string2)).keyLength);
    }

    public static String getJCEKeyAlgorithmFromURI(String string2) {
        return ((Algorithm)JCEMapper.algorithmsMap.get((Object)string2)).requiredKey;
    }

    public static String getProviderId() {
        return providerName;
    }

    public static void setProviderId(String string2) {
        providerName = string2;
    }

    static {
        providerName = null;
    }

    public static class Algorithm {
        String algorithmClass;
        String keyLength;
        String requiredKey;

        public Algorithm(Element element) {
            this.algorithmClass = element.getAttribute("AlgorithmClass");
            this.keyLength = element.getAttribute("KeyLength");
            this.requiredKey = element.getAttribute("RequiredKey");
        }
    }
}

