/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.struts;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.struts.StrutsConfigUtilities;
import org.netbeans.modules.web.struts.StrutsFrameworkProvider;
import org.netbeans.modules.web.struts.ui.StrutsConfigurationPanel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public final class StrutsUtilities {
    private StrutsUtilities() {
    }

    public static Set<FileObject> enableStruts(WebModule webModule, StrutsConfigurationPanel panel) {
        if (panel == null) {
            panel = new StrutsConfigurationPanel(null, null, true);
        }
        FileObject fo = webModule.getDocumentBase();
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        HashSet<FileObject> result = new HashSet<FileObject>();
        Library lib = LibraryManager.getDefault().getLibrary("struts");
        if (lib != null) {
            SourceGroup[] sgs = ProjectUtils.getSources((Project)project).getSourceGroups("java");
            if (sgs.length > 0) {
                try {
                    ProjectClassPathModifier.addLibraries((Library[])new Library[]{lib}, (FileObject)sgs[0].getRootFolder(), (String)"classpath/compile");
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
            try {
                FileObject webInf = webModule.getWebInf();
                if (webInf == null) {
                    webInf = FileUtil.createFolder((FileObject)webModule.getDocumentBase(), (String)"WEB-INF");
                }
                assert (webInf != null);
                FileSystem fs = webInf.getFileSystem();
                fs.runAtomicAction((FileSystem.AtomicAction)new StrutsFrameworkProvider.CreateStrutsConfig(webModule, panel));
                result.add(webModule.getDocumentBase().getFileObject("welcomeStruts", "jsp"));
            }
            catch (FileNotFoundException exc) {
                Exceptions.printStackTrace((Throwable)exc);
            }
            catch (IOException exc) {
                Logger.getLogger("global").log(Level.INFO, null, exc);
            }
        }
        return result;
    }

    public static boolean isInWebModule(WebModule wm) {
        FileObject dd = wm.getDeploymentDescriptor();
        return dd != null && StrutsConfigUtilities.getActionServlet(dd) != null;
    }
}

