/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.projects;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.dd.api.common.NameAlreadyUsedException;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.javaee.specs.support.api.JaxWs;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.wsitconf.spi.WsitProvider;
import org.netbeans.modules.websvc.wsitconf.util.ServerUtils;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class MavenWsitProvider
extends WsitProvider {
    private static final String META_INF_PATH = "src/main/resources/META-INF";
    private static final String WEB_INF_PATH = "src/main/webapp/WEB-INF";
    private static final Logger logger = Logger.getLogger(MavenWsitProvider.class.getName());
    protected static final String SERVLET_NAME = "ServletName";
    protected static final String SERVLET_CLASS = "ServletClass";
    protected static final String URL_PATTERN = "UrlPattern";
    private static final String WS_SERVLET = "com.sun.xml.ws.transport.http.servlet.WSServlet";
    private static final String WS_LISTENER = "com.sun.xml.ws.transport.http.servlet.WSServletContextListener";
    private static final String LISTENER = "Listener";
    private static final String LISTENER_CLASS = "ListenerClass";

    public MavenWsitProvider(Project p) {
        this.project = p;
    }

    @Override
    public boolean isWsitSupported() {
        SourceGroup[] sgs = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
        if (sgs != null && sgs.length > 0) {
            ClassPath classPath = ClassPath.getClassPath((FileObject)sgs[0].getRootFolder(), (String)"classpath/compile");
            FileObject txFO = classPath.findResource("com/sun/xml/ws/api/pipe/helper/AbstractPipeImpl.class");
            if (txFO != null) {
                return true;
            }
            txFO = classPath.findResource("com/sun/xml/ws/tx/service/TxServerPipe.class");
            if (txFO != null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isJsr109Project() {
        J2eePlatform j2eePlatform = ServerUtils.getJ2eePlatform(this.project);
        if (j2eePlatform != null) {
            Collection wsStacks = j2eePlatform.getLookup().lookupAll(WSStack.class);
            for (WSStack stack : wsStacks) {
                if (!stack.isFeatureSupported((WSStack.Feature)JaxWs.Feature.JSR109)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void addServiceDDEntry(String serviceImplPath, String mexUrl, String targetName) {
        boolean isGlassFish = ServerUtils.isGlassfish(this.project);
        WebModule wm = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (wm != null) {
            try {
                WebApp wApp = DDProvider.getDefault().getDDRoot(wm.getDeploymentDescriptor());
                Servlet servlet = Util.getServlet(wApp, serviceImplPath);
                if (servlet == null) {
                    try {
                        wApp.addBean(LISTENER, new String[]{LISTENER_CLASS}, new Object[]{WS_LISTENER}, LISTENER_CLASS);
                        servlet = (Servlet)wApp.addBean("Servlet", new String[]{SERVLET_NAME, SERVLET_CLASS}, new Object[]{serviceImplPath, WS_SERVLET}, SERVLET_NAME);
                        servlet.setLoadOnStartup(new BigInteger("1"));
                        wApp.addBean("ServletMapping", new String[]{SERVLET_NAME, URL_PATTERN}, new Object[]{serviceImplPath, "/" + targetName + "Service"}, URL_PATTERN);
                        wApp.addBean("ServletMapping", new String[]{SERVLET_NAME, URL_PATTERN}, new Object[]{serviceImplPath, "/" + targetName + "Service/mex"}, URL_PATTERN);
                        wApp.write(wm.getDeploymentDescriptor());
                    }
                    catch (NameAlreadyUsedException ex) {
                        ex.printStackTrace();
                    }
                    catch (ClassNotFoundException ex) {
                        ex.printStackTrace();
                    }
                } else {
                    servlet.setLoadOnStartup(new BigInteger("1"));
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public boolean addMetroLibrary() {
        Library metroLib = LibraryManager.getDefault().getLibrary("metro");
        if (metroLib != null) {
            try {
                SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
                if (sourceGroups != null && sourceGroups.length > 0) {
                    return ProjectClassPathModifier.addLibraries((Library[])new Library[]{metroLib}, (FileObject)sourceGroups[0].getRootFolder(), (String)"classpath/compile");
                }
            }
            catch (IOException e) {
                logger.log(Level.FINE, e.getMessage());
            }
        }
        return false;
    }

    @Override
    public FileObject getConfigFilesFolder(boolean client, boolean create) {
        J2eeModule.Type type;
        J2eeModule j2eeModule;
        J2eeModuleProvider provider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        if (provider != null && (j2eeModule = provider.getJ2eeModule()) != null && J2eeModule.Type.WAR.equals(type = j2eeModule.getType()) && !client) {
            FileObject dir = this.project.getProjectDirectory().getFileObject(WEB_INF_PATH);
            if (create) {
                try {
                    dir = FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), (String)WEB_INF_PATH);
                }
                catch (IOException ex) {
                    logger.log(Level.FINE, ex.getLocalizedMessage());
                }
            }
            return dir;
        }
        FileObject cfgDir = this.project.getProjectDirectory().getFileObject(META_INF_PATH);
        if (create) {
            try {
                cfgDir = FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), (String)META_INF_PATH);
            }
            catch (IOException ex) {
                logger.log(Level.FINE, ex.getLocalizedMessage());
            }
        }
        return cfgDir;
    }

    @Override
    public void createUser() {
    }
}

