/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.wsdlmodelext;

import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.WSITModelSupport;
import org.netbeans.modules.websvc.wsitmodelext.policy.Policy;
import org.netbeans.modules.websvc.wsitmodelext.policy.PolicyQName;
import org.netbeans.modules.websvc.wsitmodelext.security.SecurityPolicyQName;
import org.netbeans.modules.websvc.wsitmodelext.security.algosuite.AlgorithmSuite;
import org.netbeans.modules.websvc.wsitmodelext.security.algosuite.Basic128;
import org.netbeans.modules.websvc.wsitmodelext.security.algosuite.Basic128Rsa15;
import org.netbeans.modules.websvc.wsitmodelext.security.algosuite.Basic128Sha256;
import org.netbeans.modules.websvc.wsitmodelext.security.algosuite.Basic128Sha256Rsa15;
import org.netbeans.modules.websvc.wsitmodelext.security.algosuite.Basic192;
import org.netbeans.modules.websvc.wsitmodelext.security.algosuite.Basic192Rsa15;
import org.netbeans.modules.websvc.wsitmodelext.security.algosuite.Basic192Sha256;
import org.netbeans.modules.websvc.wsitmodelext.security.algosuite.Basic192Sha256Rsa15;
import org.netbeans.modules.websvc.wsitmodelext.security.algosuite.Basic256;
import org.netbeans.modules.websvc.wsitmodelext.security.algosuite.Basic256Rsa15;
import org.netbeans.modules.websvc.wsitmodelext.security.algosuite.Basic256Sha256;
import org.netbeans.modules.websvc.wsitmodelext.security.algosuite.Basic256Sha256Rsa15;
import org.netbeans.modules.websvc.wsitmodelext.security.algosuite.TripleDes;
import org.netbeans.modules.websvc.wsitmodelext.security.algosuite.TripleDesRsa15;
import org.netbeans.modules.websvc.wsitmodelext.security.algosuite.TripleDesSha256;
import org.netbeans.modules.websvc.wsitmodelext.security.algosuite.TripleDesSha256Rsa15;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLComponentFactory;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.Model;

public class AlgoSuiteModelHelper {
    private static HashMap<ConfigVersion, AlgoSuiteModelHelper> instances = new HashMap();
    private ConfigVersion configVersion = ConfigVersion.getDefault();

    private AlgoSuiteModelHelper(ConfigVersion configVersion) {
        this.configVersion = configVersion;
    }

    public static final AlgoSuiteModelHelper getInstance(ConfigVersion configVersion) {
        AlgoSuiteModelHelper instance = instances.get(configVersion);
        if (instance == null) {
            instance = new AlgoSuiteModelHelper(configVersion);
            instances.put(configVersion, instance);
        }
        return instance;
    }

    public static String getAlgorithmSuite(WSDLComponent comp) {
        WSDLComponent layout = AlgoSuiteModelHelper.getAlgorithmSuiteElement(comp);
        if (layout != null) {
            if (layout instanceof Basic128) {
                return ComboConstants.BASIC128;
            }
            if (layout instanceof Basic192) {
                return ComboConstants.BASIC192;
            }
            if (layout instanceof Basic256) {
                return ComboConstants.BASIC256;
            }
            if (layout instanceof TripleDes) {
                return ComboConstants.TRIPLEDES;
            }
            if (layout instanceof Basic256Rsa15) {
                return ComboConstants.BASIC256RSA15;
            }
            if (layout instanceof Basic192Rsa15) {
                return ComboConstants.BASIC192RSA15;
            }
            if (layout instanceof Basic128Rsa15) {
                return ComboConstants.BASIC128RSA15;
            }
            if (layout instanceof TripleDesRsa15) {
                return ComboConstants.TRIPLEDESRSA15;
            }
            if (layout instanceof Basic256Sha256) {
                return ComboConstants.BASIC256SHA256;
            }
            if (layout instanceof Basic192Sha256) {
                return ComboConstants.BASIC192SHA256;
            }
            if (layout instanceof Basic128Sha256) {
                return ComboConstants.BASIC128SHA256;
            }
            if (layout instanceof TripleDesSha256) {
                return ComboConstants.TRIPLEDESSHA256;
            }
            if (layout instanceof Basic256Sha256Rsa15) {
                return ComboConstants.BASIC256SHA256RSA15;
            }
            if (layout instanceof Basic192Sha256Rsa15) {
                return ComboConstants.BASIC192SHA256RSA15;
            }
            if (layout instanceof Basic128Sha256Rsa15) {
                return ComboConstants.BASIC128SHA256RSA15;
            }
            if (layout instanceof TripleDesSha256Rsa15) {
                return ComboConstants.TRIPLEDESSHA256RSA15;
            }
        }
        return null;
    }

    private static WSDLComponent getAlgorithmSuiteElement(WSDLComponent comp) {
        List elements;
        if (comp instanceof Binding || comp instanceof BindingOperation) {
            comp = SecurityPolicyModelHelper.getSecurityBindingTypeElement(comp);
        }
        if (comp == null) {
            return null;
        }
        Policy p = (Policy)PolicyModelHelper.getTopLevelElement(comp, Policy.class, false);
        AlgorithmSuite as = (AlgorithmSuite)PolicyModelHelper.getTopLevelElement((WSDLComponent)p, AlgorithmSuite.class, false);
        if ((p = (Policy)PolicyModelHelper.getTopLevelElement((WSDLComponent)as, Policy.class, false)) != null && (elements = p.getExtensibilityElements()) != null && !elements.isEmpty()) {
            ExtensibilityElement e = (ExtensibilityElement)elements.get(0);
            return e;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAlgorithmSuite(WSDLComponent c, String algoSuite) {
        WSDLModel model = c.getModel();
        WSDLComponentFactory wcf = model.getFactory();
        WSDLComponent topElem = c;
        boolean isTransaction = model.isIntransaction();
        if (!isTransaction) {
            model.startTransaction();
        }
        try {
            QName qnameToCreate = null;
            if (ComboConstants.BASIC128.equals(algoSuite)) {
                qnameToCreate = SecurityPolicyQName.BASIC128.getQName(this.configVersion);
            } else if (ComboConstants.BASIC192.equals(algoSuite)) {
                qnameToCreate = SecurityPolicyQName.BASIC192.getQName(this.configVersion);
            } else if (ComboConstants.BASIC256.equals(algoSuite)) {
                qnameToCreate = SecurityPolicyQName.BASIC256.getQName(this.configVersion);
            } else if (ComboConstants.TRIPLEDES.equals(algoSuite)) {
                qnameToCreate = SecurityPolicyQName.TRIPLEDES.getQName(this.configVersion);
            } else if (ComboConstants.BASIC128RSA15.equals(algoSuite)) {
                qnameToCreate = SecurityPolicyQName.BASIC128RSA15.getQName(this.configVersion);
            } else if (ComboConstants.BASIC192RSA15.equals(algoSuite)) {
                qnameToCreate = SecurityPolicyQName.BASIC192RSA15.getQName(this.configVersion);
            } else if (ComboConstants.BASIC256RSA15.equals(algoSuite)) {
                qnameToCreate = SecurityPolicyQName.BASIC256RSA15.getQName(this.configVersion);
            } else if (ComboConstants.TRIPLEDESRSA15.equals(algoSuite)) {
                qnameToCreate = SecurityPolicyQName.TRIPLEDESRSA15.getQName(this.configVersion);
            } else if (ComboConstants.BASIC128SHA256.equals(algoSuite)) {
                qnameToCreate = SecurityPolicyQName.BASIC128SHA256.getQName(this.configVersion);
            } else if (ComboConstants.BASIC192SHA256.equals(algoSuite)) {
                qnameToCreate = SecurityPolicyQName.BASIC192SHA256.getQName(this.configVersion);
            } else if (ComboConstants.BASIC256SHA256.equals(algoSuite)) {
                qnameToCreate = SecurityPolicyQName.BASIC256SHA256.getQName(this.configVersion);
            } else if (ComboConstants.TRIPLEDESSHA256.equals(algoSuite)) {
                qnameToCreate = SecurityPolicyQName.TRIPLEDESSHA256.getQName(this.configVersion);
            } else if (ComboConstants.BASIC128SHA256RSA15.equals(algoSuite)) {
                qnameToCreate = SecurityPolicyQName.BASIC128SHA256RSA15.getQName(this.configVersion);
            } else if (ComboConstants.BASIC192SHA256RSA15.equals(algoSuite)) {
                qnameToCreate = SecurityPolicyQName.BASIC192SHA256RSA15.getQName(this.configVersion);
            } else if (ComboConstants.BASIC256SHA256RSA15.equals(algoSuite)) {
                qnameToCreate = SecurityPolicyQName.BASIC256SHA256RSA15.getQName(this.configVersion);
            } else if (ComboConstants.TRIPLEDESSHA256RSA15.equals(algoSuite)) {
                qnameToCreate = SecurityPolicyQName.TRIPLEDESSHA256RSA15.getQName(this.configVersion);
            }
            PolicyModelHelper pmh = PolicyModelHelper.getInstance(this.configVersion);
            AlgorithmSuite suite = (AlgorithmSuite)pmh.createElement(topElem, SecurityPolicyQName.ALGORITHMSUITE.getQName(this.configVersion), AlgorithmSuite.class, !(topElem instanceof Policy));
            List policies = suite.getExtensibilityElements(Policy.class);
            if (policies != null && !policies.isEmpty()) {
                for (Policy pol : policies) {
                    suite.removeExtensibilityElement((ExtensibilityElement)pol);
                }
            }
            Policy p = (Policy)pmh.createElement((WSDLComponent)suite, PolicyQName.POLICY.getQName(this.configVersion), Policy.class, false);
            ExtensibilityElement e = (ExtensibilityElement)wcf.create((WSDLComponent)p, qnameToCreate);
            p.addExtensibilityElement(e);
        }
        finally {
            if (!isTransaction) {
                WSITModelSupport.doEndTransaction((Model)model);
            }
        }
    }
}

