/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import org.clank.java.std_pair;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.type;
import org.llvm.adt.aliases.DenseMapInfoInt;

public class DenseMapIteratorIntType<ValueT>
implements type.iterator<DenseMapIteratorIntType<ValueT>, std_pair.pairIntType<ValueT>>,
Cloneable {
    private final DenseMapInfoInt keyInfoT;
    private std_pair.pairIntType<ValueT>[] Buckets;
    private int Ptr;
    private int End;
    private static final int INVALID_INDEX = Integer.MAX_VALUE;

    protected DenseMapIteratorIntType() {
        this.keyInfoT = null;
        this.Ptr = Integer.MAX_VALUE;
        this.End = Integer.MAX_VALUE;
        this.Buckets = null;
    }

    public DenseMapIteratorIntType(DenseMapInfoInt keyInfoT) {
        this.keyInfoT = keyInfoT;
        this.Ptr = Integer.MAX_VALUE;
        this.End = Integer.MAX_VALUE;
        this.Buckets = null;
    }

    public DenseMapIteratorIntType(DenseMapInfoInt keyInfoT, std_pair.pairIntType<ValueT>[] Buckets, int Pos, int E) {
        this(keyInfoT, Buckets, Pos, E, false);
    }

    public DenseMapIteratorIntType(DenseMapInfoInt keyInfoT, std_pair.pairIntType<ValueT>[] Buckets, int Pos, int E, boolean NoAdvance) {
        this.keyInfoT = keyInfoT;
        this.Ptr = Pos;
        this.End = E;
        this.Buckets = Buckets;
        if (!NoAdvance) {
            this.AdvancePastEmptyBuckets();
        }
    }

    public DenseMapIteratorIntType<ValueT> $assignMove(DenseMapIteratorIntType<ValueT> other) {
        this.End = other.End;
        this.Buckets = other.Buckets;
        this.Ptr = other.Ptr;
        return this;
    }

    public DenseMapIteratorIntType(DenseMapIteratorIntType<ValueT> I) {
        this.keyInfoT = I.keyInfoT;
        this.Ptr = I.Ptr;
        this.End = I.End;
        this.Buckets = I.Buckets;
    }

    public std_pair.pairIntType<ValueT> $star() {
        return this.Buckets[this.Ptr];
    }

    public type.ref<std_pair.pairIntType<ValueT>> star$ref() {
        return new type.ref<std_pair.pairIntType<ValueT>>(){
            int localPtr;
            {
                this.localPtr = DenseMapIteratorIntType.this.Ptr;
            }

            public std_pair.pairIntType<ValueT> $deref() {
                return DenseMapIteratorIntType.this.Buckets[this.localPtr];
            }

            public std_pair.pairIntType<ValueT> $set(std_pair.pairIntType<ValueT> value) {
                std_pair.pairIntType pairIntType2 = value;
                ((DenseMapIteratorIntType)DenseMapIteratorIntType.this).Buckets[this.localPtr] = pairIntType2;
                return pairIntType2;
            }

            public type.ptr<std_pair.pairIntType<ValueT>> deref$ptr() {
                return NativePointer.create_type$ptr((Object[])DenseMapIteratorIntType.this.Buckets, (int)this.localPtr);
            }
        };
    }

    public std_pair.pairIntType<ValueT> $arrow() {
        return this.$star();
    }

    public boolean $eq(DenseMapIteratorIntType<ValueT> RHS) {
        assert (this.Buckets == RHS.Buckets);
        return this.Ptr == RHS.Ptr;
    }

    public boolean $noteq(DenseMapIteratorIntType<ValueT> RHS) {
        assert (this.Buckets == RHS.Buckets);
        return this.Ptr != RHS.Ptr;
    }

    public DenseMapIteratorIntType<ValueT> $preInc() {
        ++this.Ptr;
        this.AdvancePastEmptyBuckets();
        return this;
    }

    public DenseMapIteratorIntType<ValueT> $postInc() {
        DenseMapIteratorIntType<ValueT> tmp = new DenseMapIteratorIntType<ValueT>(this.keyInfoT, this.Buckets, this.Ptr, this.End, true);
        ++this.Ptr;
        return tmp;
    }

    private void AdvancePastEmptyBuckets() {
        int Empty = this.keyInfoT.getEmptyKey();
        int Tombstone = this.keyInfoT.getTombstoneKey();
        while (Native.$noteq((int)this.Ptr, (int)this.End) && (this.Buckets[this.Ptr].first == Empty || this.Buckets[this.Ptr].first == Tombstone)) {
            ++this.Ptr;
        }
    }

    public DenseMapIteratorIntType<ValueT> clone() {
        return new DenseMapIteratorIntType<ValueT>(this.keyInfoT, this.Buckets, this.Ptr, this.End, true);
    }

    public DenseMapIteratorIntType<ValueT> const_clone() {
        return new DenseMapIteratorIntType<ValueT>(this.keyInfoT, this.Buckets, this.Ptr, this.End, true);
    }

    public boolean $eq(Object other) {
        if (other instanceof DenseMapIteratorIntType) {
            return Native.$eq((int)this.Ptr, (int)((DenseMapIteratorIntType)other).Ptr);
        }
        return false;
    }

    public boolean $noteq(Object other) {
        if (other instanceof DenseMapIteratorIntType) {
            return Native.$noteq((int)this.Ptr, (int)((DenseMapIteratorIntType)other).Ptr);
        }
        return true;
    }
}

